% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-filterp.R
\name{filterp,purityD-method}
\alias{filterp,purityD-method}
\alias{filterp}
\title{Filter out peaks based on intensity and RSD criteria}
\usage{
\S4method{filterp}{purityD}(Object, thr = 5000, rsd = 20, sampleOnly = TRUE)
}
\arguments{
\item{Object}{object; purityD object}

\item{thr}{numeric; intensity threshold}

\item{rsd}{numeric; rsd threshold}

\item{sampleOnly}{boolean; if only the sample (not blanks) should be filtered}
}
\value{
purityD object
}
\description{
Uses a purityD object remove peaks from either (or both) samples and
blanks that are either below an intensity threshold
or greater than a Relative Standard Deviation (RSD) threshold
}
\examples{

datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)

ppDIMS <- purityD(inDF, cores=1)
ppDIMS <- averageSpectra(ppDIMS)
ppDIMS <- filterp(ppDIMS, thr = 5000)
}
