% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_motifs.R
\docType{methods}
\name{motifMatches}
\alias{motifMatches}
\alias{motifMatches,SummarizedExperiment-method}
\title{motifMatches}
\usage{
motifMatches(object)

\S4method{motifMatches}{SummarizedExperiment}(object)
}
\arguments{
\item{object}{SummarizedExperiment object with matches assay}
}
\value{
matrix with scores
}
\description{
get motif matches from SummarizedExperiment object
}
\section{Methods (by class)}{
\itemize{
\item \code{SummarizedExperiment}: method for SummarizedExperiment
}}

\examples{

data(example_motifs, package = "motifmatchr")

# Make a set of peaks
peaks <- GenomicRanges::GRanges(seqnames = c("chr1","chr2","chr2"),
                ranges = IRanges::IRanges(start = c(76585873,42772928,
                                          100183786),
                                          width = 500))

# Get motif matches for example motifs
motif_ix <- matchMotifs(example_motifs, peaks,
                        genome = "BSgenome.Hsapiens.UCSC.hg19")

motifMatches(motif_ix)
}
