% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreProfile}
\alias{scoreProfile}
\title{Score profile across multiple sequences}
\usage{
scoreProfile(seqs, pfm, bg)
}
\arguments{
\item{seqs}{A DNAStringSet or DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{fscores}{Vector of per-position average forward strand scores}
\item{rscores}{Vector of per-position average reverse strand scores}
}
}
\description{
This function computes the per-position and per-strand
average score profiles across a set of DNA sequences.
It can be used to reveal positional constraints
of TFBSs.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the score profile
scoreProfile(seqs, motif, bg)

}
