% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wrapper.R
\name{generateDNAString}
\alias{generateDNAString}
\title{Generate DNAString}
\usage{
generateDNAString(len, bg)
}
\arguments{
\item{len}{Integer length of the sequence}

\item{bg}{A Background object}
}
\value{
A DNAString object
}
\description{
This function generates a random DNAString of a given length
by sampling from the background model.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Generate a 1 kb random sequence
motifcounter:::generateDNAString(1000, bg)

}
\seealso{
\code{\link{generateDNAStringSet}}
}
