% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus.from.rsid.R
\name{snps.from.file}
\alias{snps.from.file}
\alias{variants.from.file}
\title{Import SNPs from a BED file or VCF file for use in motifbreakR}
\usage{
snps.from.file(
  file = NULL,
  dbSNP = NULL,
  search.genome = NULL,
  format = "bed",
  indels = FALSE,
  biomart.dataset = NULL,
  check.unnamed.for.rsid = FALSE
)

variants.from.file(
  file = NULL,
  dbSNP = NULL,
  search.genome = NULL,
  biomart.dataset = NULL,
  format = "bed"
)
}
\arguments{
\item{file}{Character; a character containing the path to a bed file or a vcf file
see Details for a description of the required format}

\item{dbSNP}{OPTIONAL; an object of class SNPlocs to lookup rsids; see \code{availible.SNPs} in
\code{\link[BSgenome]{injectSNPs}} to check for availible SNPlocs}

\item{search.genome}{an object of class BSgenome for the species you are interrogating;
see \code{\link[BSgenome]{available.genomes}} for a list of species}

\item{format}{Character; one of \code{bed} or \code{vcf}}

\item{indels}{Logical; allow the import of indels.}

\item{biomart.dataset}{a Mart object from \code{\link{useEnsembl}} specifying
the \code{snps} biomart, which dataset i.e., \code{hsapiens_snp}, and which
version i.e., \code{111} or \code{GRCm39}. This will override \code{SNPlocs} and must
be compatible with search.genome selection, and will query from \code{biomaRt},
which may be considerably faster than a lookup from a \code{SNPlocs} object.}

\item{check.unnamed.for.rsid}{Logical; check snps in the form chr:pos:ref:alt
for corresponding rsid, lookup may be slow, requires either param dbSNP or biomart.dataset.}
}
\value{
a GRanges object containing:
 \item{SNP_id}{The rsid of the snp with the "rs" portion stripped}
 \item{alleles_as_ambig}{THE IUPAC ambiguity code between the reference and
 alternate allele for this SNP}
 \item{REF}{The reference allele for the SNP}
 \item{ALT}{The alternate allele for the SNP}
}
\description{
Import SNPs from a BED file or VCF file for use in motifbreakR
}
\details{
\code{snps.from.file} takes a character vector describing the file path
 to a bed file that contains the necissary information to generate the input for
 \code{motifbreakR} see \url{http://www.genome.ucsc.edu/FAQ/FAQformat.html#format1}
 for a complete description of the BED format.  Our convention deviates in that there
 is a required format for the name field.  \code{name} is defined as chromosome:start:REF:ALT
 or the rsid from dbSNP (if you've included the optional SNPlocs argument).
 For example if you were to include rs123 in it's alternate
 format it would be entered as chr7:24966446:C:A
}
\section{Functions}{
\itemize{
\item \code{variants.from.file()}: Allows the use of indels by default

}}
\examples{
 library(BSgenome.Drerio.UCSC.danRer7)
 library(SNPlocs.Hsapiens.dbSNP155.GRCh37)
 snps.bed.file <- system.file("extdata", "danRer.bed", package = "motifbreakR")
 # see the contents
 read.table(snps.bed.file, header = FALSE)
 #import the BED file
 snps.mb <- snps.from.file(snps.bed.file,
                           search.genome = BSgenome.Drerio.UCSC.danRer7,
                           format = "bed")

}
\seealso{
See \code{\link{motifbreakR}} for analysis; See \code{\link{snps.from.rsid}}
  for an alternate method for generating a list of variants.
}
