% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMotif.R
\name{motifbreakR}
\alias{motifbreakR}
\title{Predict The Disruptiveness Of Single Nucleotide Polymorphisms On
Transcription Factor Binding Sites.}
\usage{
motifbreakR(
  snpList,
  pwmList,
  threshold = 0.85,
  filterp = FALSE,
  method = "default",
  show.neutral = FALSE,
  verbose = FALSE,
  bkg = c(A = 0.25, C = 0.25, G = 0.25, T = 0.25),
  BPPARAM = bpparam()
)
}
\arguments{
\item{snpList}{The output of \code{snps.from.rsid} or \code{snps.from.file}}

\item{pwmList}{An object of class \code{MotifList} containing the motifs that
you wish to interrogate}

\item{threshold}{Numeric; the maximum p-value for a match to be called or a minimum score threshold}

\item{filterp}{Logical; filter by p-value instead of by pct score.}

\item{method}{Character; one of \code{default}, \code{log}, \code{ic}, or \code{notrans}; see
details.}

\item{show.neutral}{Logical; include neutral changes in the output}

\item{verbose}{Logical; if running serially, show verbose messages}

\item{bkg}{Numeric Vector; the background probabilites of the nucleotides
used with method=\code{log} method=\code{ic}}

\item{BPPARAM}{a BiocParallel object see \code{\link[BiocParallel]{register}}
and see \code{getClass("BiocParallelParam")} for additional parameter
classes.  Try \code{BiocParallel::registered()} to see what's availible and
for example \code{BiocParallel::bpparam("SerialParam")} would allow serial
evaluation.}
}
\value{
a GRanges object containing:
 \item{REF}{the reference allele for the variant}
 \item{ALT}{the alternate allele for the variant}
 \item{snpPos}{the coordinates of the variant}
 \item{motifPos}{The position of the motif relative the the variant}
 \item{geneSymbol}{the geneSymbol corresponding to the TF of the TF binding motif}
 \item{dataSource}{the source of the TF binding motif}
 \item{providerName, providerId}{the name and id provided by the source}
 \item{seqMatch}{the sequence on the 5' -> 3' direction of the "+" strand
 that corresponds to DNA at the position that the TF binding motif was found.}
 \item{pctRef}{The score as determined by the scoring method, when the sequence contains the reference variant allele, normalized to a scale from 0 - 1. If \code{filterp = FALSE},
 this is the value that is thresholded.}
 \item{pctAlt}{The score as determined by the scoring method, when the sequence contains the alternate variant allele, normalized to a scale from 0 - 1. If \code{filterp = FALSE},
 this is the value that is thresholded.}
 \item{scoreRef}{The score as determined by the scoring method, when the sequence contains the reference variant allele}
 \item{scoreAlt}{The score as determined by the scoring method, when the sequence contains the alternate variant allele}
 \item{Refpvalue}{p-value for the match for the pctRef score, initially set to \code{NA}. see \code{\link{calculatePvalue}} for more information}
 \item{Altpvalue}{p-value for the match for the pctAlt score, initially set to \code{NA}. see \code{\link{calculatePvalue}} for more information}
 \item{altPos}{the position, relative to the reference allele, of the alternate allele}
 \item{alleleDiff}{The difference between the score on the reference allele and the score on the alternate allele}
 \item{alleleEffectSize}{The ratio of the \code{alleleDiff} and the maximal score of a sequence under the PWM}
 \item{effect}{one of weak, strong, or neutral indicating the strength of the effect.}
 each SNP in this object may be plotted with \code{\link{plotMB}}
}
\description{
Predict The Disruptiveness Of Single Nucleotide Polymorphisms On
Transcription Factor Binding Sites.
}
\details{
\pkg{motifbreakR} works with position probability matrices (PPM). PPM
are derived as the fractional occurrence of nucleotides A,C,G, and T at
each position of a position frequency matrix (PFM). PFM are simply the
tally of each nucleotide at each position across a set of aligned
sequences. With a PPM, one can generate probabilities based on the
genome, or more practically, create any number of position specific
scoring matrices (PSSM) based on the principle that the PPM contains
information about the likelihood of observing a particular nucleotide at
a particular position of a true transcription factor binding site. What
follows is a discussion of the three different algorithms that may be
employed in calls to the \pkg{motifbreakR} function via the \code{method}
argument.

Suppose we have a frequency matrix \eqn{M} of width \eqn{n} (\emph{i.e.} a
PPM as described above). Furthermore, we have a sequence \eqn{s} also of
length \eqn{n}, such that
\eqn{s_{i} \in \{ A,T,C,G \}, i = 1,\ldots n}{s_i in {A,T,G,C}, i = 1 \ldots n}.
Each column of
\eqn{M} contains the frequencies of each letter in each position.

Commonly in the literature sequences are scored as the sum of log
probabilities:

\strong{Equation 1}

\deqn{F( s,M ) = \sum_{i = 1}^{n}{\log( \frac{M_{s_{i},i}}{b_{s_{i}}} )}}{
F( s,M ) = \sum_(i = 1)^n log ((M_s_i,_i)/b_s_i)}

where \eqn{b_{s_{i}}}{b_s_i} is the background frequency of letter \eqn{s_{i}}{s_i} in
the genome of interest. This method can be specified by the user as
\code{method='log'}.

As an alternative to this method, we introduced a scoring method to
directly weight the score by the importance of the position within the
match sequence. This method of weighting is accessed by specifying
\code{method='ic'} (information content). A general representation
of this scoring method is given by:

\strong{Equation 2}

\deqn{F( s,M ) = p_{s} \cdot \omega_{M}}{F( s,M ) = p_s . \omega_M}

where \eqn{p_{s}}{p_s} is the scoring vector derived from sequence \eqn{s} and matrix
\eqn{M}, and \eqn{w_{M}}{w_M} is a weight vector derived from \eqn{M}. First, we
compute the scoring vector of position scores \eqn{p}

\strong{Equation 3}

\deqn{p_{s} = ( M_{s_{i},i} ) \textrm{\ \ \ where\ \ \ } \frac{i = 1,\ldots n}{s_{i} \in \{ A,C,G,T \}}}{
p_s = ( M_s_i,_i ) where (i = 1 \ldots n)/(s_i in {A,C,G,T})}

and second, for each \eqn{M} a constant vector of weights
\eqn{\omega_{M} = ( \omega_{1},\omega_{2},\ldots,\omega_{n} )}{\omega_M = ( \omega_1, \omega_2, \ldots, \omega_n)}.

There are two methods for producing \eqn{\omega_{M}}{\omega_M}. The first, which we
call weighted sum, is the difference in the probabilities for the two
letters of the polymorphism (or variant), \emph{i.e.}
\eqn{\Delta p_{s_{i}}}{\Delta p_s_i}, or the difference of the maximum and minimum
values for each column of \eqn{M}:

\strong{Equation 4.1}

\deqn{\omega_{i} = \max \{ M_{i} \} - \min \{ M_{i} \}\textrm{\ \ \ \ where\ \ \ \ \ \ }i = 1,\ldots n}{
\omega_i = max{M_i} - min{M_i} where i = 1 \ldots n}

The second variation of this theme is to weight by relative entropy.
Thus the relative entropy weight for each column \eqn{i} of the matrix is
given by:

\strong{Equation 4.2}

\deqn{\omega_{i} = \sum_{j \in \{ A,C,G,T \}}^{}{M_{j,i}\log_2( \frac{M_{j,i}}{b_{i}} )}\textrm{\ \ \ \ \ where\ \ \ \ \ }i = 1,\ldots n}{
\omega_i = \sum_{j in {A,C,G,T}} {M_(j,i)} log2(M_(j,i)/b_i) where i = 1 \ldots n}

where \eqn{b_{i}}{b_i} is again the background frequency of the letter \eqn{i}.

Thus, there are 3 possible algorithms to apply via the \code{method}
argument. The first is the standard summation of log probabilities
(\code{method='log'}). The second and third are the weighted sum and
information content methods (\code{method='default'} and \code{method='ic'}) specified by
equations 4.1 and 4.2, respectively. \pkg{motifbreakR} assumes a
uniform background nucleotide distribution (\eqn{b}) in equations 1 and
4.2 unless otherwise specified by the user. Since we are primarily
interested in the difference between alleles, background frequency is
not a major factor, although it can change the results. Additionally,
inclusion of background frequency introduces potential bias when
collections of motifs are employed, since motifs are themselves
unbalanced with respect to nucleotide composition. With these cautions
in mind, users may override the uniform distribution if so desired. For
all three methods, \pkg{motifbreakR} scores and reports the reference
and alternate alleles of the sequence
(\eqn{F( s_{\textsc{ref}},M )}{F( s_ref,M )} and
\eqn{F( s_{\textsc{alt}},M )}{F( s_alt,M )}), and provides the matrix scores
\eqn{p_{s_{\textsc{ref}}}}{p_s_ref} and \eqn{p_{s_{\textsc{alt}}}}{p_s_alt} of the SNP (or
variant). The scores are scaled as a fraction of scoring range 0-1 of
the motif matrix, \eqn{M}. If either of
\eqn{F( s_{\textsc{ref}},M )}{F( s_ref,M )} and
\eqn{F( s_{\textsc{alt}},M )}{F( s_alt,M )} is greater than a user-specified
threshold (default value of 0.85) the SNP is reported. By default
\pkg{motifbreakR} does not display neutral effects,
(\eqn{\Delta p_{i} < 0.4}{\Delta p_i < 0.4}) but this behaviour can be
overridden.

Additionally, now, with the use of \code{\link{TFMPvalue-package}}, we may filter by p-value of the match.
This is unfortunately a two step process. First, by invoking \code{filterp=TRUE} and setting a threshold at
a desired p-value e.g 1e-4, we perform a rough filter on the results by rounding all values in the PWM to two
decimal place, and calculating a scoring threshold based upon that. The second step is to use the function \code{\link{calculatePvalue}()}
on a selection of results which will change the \code{Refpvalue} and \code{Altpvalue} columns in the output from \code{NA} to the p-value
calculated by \code{\link{TFMsc2pv}}.  This can be (although not always) a very memory and time intensive process if the algorithm doesn't converge rapidly.
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 # prepare variants
 load(system.file("extdata",
                  "pca.enhancer.snps.rda",
                  package = "motifbreakR")) # loads snps.mb
 pca.enhancer.snps <- sample(snps.mb, 20)
 # Get motifs to interrogate
 data(hocomoco)
 motifs <- sample(hocomoco, 50)
 # run motifbreakR
 results <- motifbreakR(pca.enhancer.snps,
                        motifs, threshold = 0.85,
                        method = "ic",
                        BPPARAM=BiocParallel::SerialParam())
}
\seealso{
See \code{\link{snps.from.rsid}} and \code{\link{snps.from.file}} for
  information about how to generate the input to this function and
  \code{\link{plotMB}} for information on how to visualize it's output
}
