% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_plot.R
\name{get_expr_values}
\alias{get_expr_values}
\title{Get expression values}
\usage{
get_expr_values(
  de_container,
  gene,
  intgroup,
  assay = "counts",
  normalized = TRUE
)
}
\arguments{
\item{de_container}{An object containing the data for a Differential
Expression workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqDataSet} object, normally obtained after
running your data through the \code{DESeq2} framework.}

\item{gene}{Character, specifies the identifier of the feature (gene) to be
extracted}

\item{intgroup}{A character vector of names in \code{colData(de_container)} to use for
grouping.}

\item{assay}{Character, specifies with assay of the \code{de_container} object to use for
reading out the expression values. Defaults to "counts".}

\item{normalized}{Logical value, whether the expression values should be
normalized by their size factor. Defaults to TRUE, applies when \code{assay} is
"counts"}
}
\value{
A tidy data.frame with the expression values and covariates for
further processing
}
\description{
Extract expression values, with the possibility to select other assay slots
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data(gse, package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
keep <- rowSums(counts(dds_macrophage) >= 10) >= 6
dds_macrophage <- dds_macrophage[keep, ]
# dds_macrophage <- DESeq(dds_macrophage)

df_exp <- get_expr_values(
  de_container = dds_macrophage,
  gene = "ENSG00000125347",
  intgroup = "condition"
)
head(df_exp)
}
