% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_kmers.R
\name{getKmerFreq}
\alias{getKmerFreq}
\title{Calculate observed and expected k-mer frequencies}
\usage{
getKmerFreq(
  seqs,
  kmerLen = 5,
  MMorder = 1,
  pseudocount = 1,
  zoops = TRUE,
  strata = rep(1L, length(seqs)),
  p.adjust.method = "BH",
  includeRevComp = TRUE
)
}
\arguments{
\item{seqs}{Set of sequences, either a \code{character} vector or a
\code{\link[Biostrings]{DNAStringSet}}.}

\item{kmerLen}{A \code{numeric} scalar giving the k-mer length.}

\item{MMorder}{A \code{numeric} scalar giving the order of the Markov model
used to calculate the expected frequencies.}

\item{pseudocount}{A \code{numeric} scalar - will be added to the observed
counts for each k-mer to avoid zero values.}

\item{zoops}{A \code{logical} scalar. If \code{TRUE} (the default), only one
or zero occurences of a k-mer are considered per sequence.}

\item{strata}{A \code{factor} or a \code{numeric} scalar defining the strata
of sequences. A separate Markov model and expected k-mer frequencies are
estimated for the set of sequences in each stratum (level in a
\code{strata} factor). If \code{strata} is a scalar value, it will be
interpreted as the number of strata to split the sequences into according
to their CpG observed-over-expected counts using
\code{kmeans(CpGoe, centers = strata)}.}

\item{p.adjust.method}{A character scalar selecting the p value adjustment
method (used in \code{\link[stats]{p.adjust}}).}

\item{includeRevComp}{A \code{logical} scalar. If \code{TRUE} (default),
count k-mer occurrences in both \code{seqs} and their reverse-complement,
by concatenating \code{seqs} and their reverse-complemented versions
before the counting. This is useful if motifs can be expected to occur
on any strand (e.g. DNA sequences of ChIP-seq peaks). If motifs are only
expected on the forward strand (e.g. RNA sequences of CLIP-seq peaks),
\code{includeRevComp = FALSE} should be used. Note that if \code{strata}
is a vector of the same length as \code{seqs}, each reverse-complemented
sequence will be assigned to the same stratum as the forward sequence.}
}
\value{
A \code{list} with observed and expected k-mer frequencies
  (\code{freq.obs} and \code{freq.exp}, respectively), and enrichment
  statistics for each k-mer.
}
\description{
Given a set of sequences, calculate observed and expected k-mer
  frequencies. Expected frequencies are based on a Markov model of order
  \code{MMorder}.
}
\examples{
res <- getKmerFreq(seqs = c("AAAAATT", "AAATTTT"), kmerLen = 3)
names(res)
head(res$freq.obs)
head(res$freq.exp)

}
