% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{getColsByBin}
\alias{getColsByBin}
\title{Get colors by bin.}
\usage{
getColsByBin(
  b,
  col1 = c("#003C30", "#01665E", "#35978F", "#80CDC1", "#C7EAE5"),
  col2 = c("#F6E8C3", "#DFC27D", "#BF812D", "#8C510A", "#543005"),
  col0 = "#F5F5F5"
)
}
\arguments{
\item{b}{A factor that groups elements into bins (typically the output of
\code{\link{bin}}).}

\item{col1}{First color.}

\item{col2}{Second color.}

\item{col0}{Neutral color.}
}
\value{
A character vector with colors for the elements in \code{b}.
}
\description{
Get colors for elements according to their bin.
    Colors are assigned to bins forming a gradient from \code{col1}
    to \code{col2} in the order of \code{levels{b}}. \code{col0} is assigned
    to the neutral bin (attribute \code{""}) if available.
}
\examples{
set.seed(1)
x <- rnorm(100)
b <- bin(x, "equalN", nElements = 10)
cols <- getColsByBin(b)

}
\seealso{
\code{\link{bin}}.
}
