% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{plotDnf}
\alias{plotDnf}
\title{Plot disjunctive normal form.}
\usage{
plotDnf(
  dnf = NULL,
  freq = NULL,
  stimuli = c(),
  signals = c(),
  inhibitors = c(),
  connected = TRUE,
  CNOlist = NULL,
  cex = NULL,
  fontsize = NULL,
  labelsize = NULL,
  type = 2,
  lwd = 1,
  edgelwd = 1,
  legend = 0,
  x = 0,
  y = 0,
  xjust = 0,
  yjust = 0,
  width = 1,
  height = 1,
  layout = "dot",
  main = "",
  sub = "",
  cex.main = 1.5,
  cex.sub = 1,
  col.sub = "grey",
  fontcolor = NULL,
  nodestates = NULL,
  simulate = NULL,
  edgecol = NULL,
  labels = NULL,
  labelcol = "blue",
  nodelabel = NULL,
  nodecol = NULL,
  bordercol = NULL,
  nodeshape = NULL,
  verbose = FALSE,
  edgestyle = NULL,
  nodeheight = NULL,
  nodewidth = NULL,
  edgewidth = NULL,
  lty = NULL,
  hierarchy = NULL,
  showall = FALSE,
  edgehead = NULL,
  edgelabel = NULL,
  edgetail = NULL,
  bool = TRUE,
  draw = TRUE,
  ...
)
}
\arguments{
\item{dnf}{Hyper-graph in disjunctive normal form,
e.g. c("A=B", "A=C+D", "E=!B") with the child on the left and the parents
on the right of the equation with "A=C+D" for A = C AND D. Alternatively,
dnf can be an adjacency matrix, which is converted on the fly to a
disjunctive normal form.}

\item{freq}{Frequency of hyper-edges which are placed on the edges.}

\item{stimuli}{Highlights vertices which can be stimulated.}

\item{signals}{Highlights vertices which regulate E-genes.}

\item{inhibitors}{Highlights vertices which can be inhibited.}

\item{connected}{If TRUE, only includes vertices which are connected to other
vertices.}

\item{CNOlist}{CNOlist object. Optional instead of stimuli, inhibitors or
signals. See package CellNOptR.}

\item{cex}{Global font size.}

\item{fontsize}{Vertice label size.}

\item{labelsize}{Edge label size.}

\item{type}{Different plot types. 2 for Rgraphviz and 1 for graph.}

\item{lwd}{Line width of nodeborder.}

\item{edgelwd}{Global edgeline width.}

\item{legend}{0 shows no legend. 1 shows legend as a graph. 2 shows legend
in a standard box.}

\item{x}{x coordinate of box legend.}

\item{y}{y coordinate of box legend.}

\item{xjust}{Justification of legend box left, right or center (-1,1,0).}

\item{yjust}{Justification of legend box top, bottom or middle (-1,1,0).}

\item{width}{Vertice width.}

\item{height}{Vertice height.}

\item{layout}{Graph layout. See graphvizCapabilities()$layoutTypes.}

\item{main}{Main title.}

\item{sub}{Subtitle.}

\item{cex.main}{Main title font size.}

\item{cex.sub}{Subtitle font size.}

\item{col.sub}{Font color of subtitle.}

\item{fontcolor}{Global font color.}

\item{nodestates}{Binary state of each vertice.}

\item{simulate}{Simulate stimulation and inhibition of a list of vertices.
E.g. simulate = list(stimuli = c("A", "B"), inhibitors = c("C", "D")).}

\item{edgecol}{Vector with colors for every edge of the graph
(not hyper-graph). E.g. an AND gate consists of three distinct edges.}

\item{labels}{Vector with labels for the edges.}

\item{labelcol}{Vector with label colors for the edges.}

\item{nodelabel}{List of vertices with labels as input.
E.g. labels = list(A="test", B="label for B").}

\item{nodecol}{List of vertices with colors as input.}

\item{bordercol}{List of vertices with colors as input.}

\item{nodeshape}{List of vertices with shapes (diamond, box, square,...).}

\item{verbose}{Verbose output.}

\item{edgestyle}{set the edge style like dashed, can be numerical}

\item{nodeheight}{List of vertices with height as input.}

\item{nodewidth}{List of vertices with width as input.}

\item{edgewidth}{Vector with edge widths for individual edges.}

\item{lty}{Vector with edge styles (line, dotted,...).}

\item{hierarchy}{List with the hierarchy of the vertices.
E.g. list(top = c("A", "B"), bottom = c("C", "D")).}

\item{showall}{See "connected" above.}

\item{edgehead}{Vector with edge heads.}

\item{edgelabel}{Vector with edge labels.}

\item{edgetail}{Vector with edge tails.}

\item{bool}{If TRUE, only shows normal graph and no AND gates.}

\item{draw}{Do not plot the graph and only output the graphNEL object.}

\item{\dots}{additional arguments}
}
\value{
Rgraphviz object
}
\description{
This function visualizes a graph encoded as a disjunctive nromal form. See
the graphviz documentation for possible input arguments, like edgehead/tail:
https://graphviz.org/docs/attr-types/arrowType/
}
\examples{
g <- c("!A+B+C=G", "C=G", "!D=G")
plotDnf(g)
}
\author{
Martin Pirkl
}
