% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{getAffinity}
\alias{getAffinity}
\title{Calculate responsibilities.}
\usage{
getAffinity(
  x,
  affinity = 0,
  norm = TRUE,
  logtype = 2,
  mw = NULL,
  data = matrix(0, 2, ncol(x)),
  complete = FALSE
)
}
\arguments{
\item{x}{log odds for l cells and k components as a kxl matrix}

\item{affinity}{0 for standard soft clustering, 1 for hard clustering
during inference (not recommended)}

\item{norm}{if TRUE normalises to probabilities (recommended)}

\item{logtype}{logarithm type of the data (e.g. 2 for log2 data or exp(1)
for natural)}

\item{mw}{mixture weights of the components}

\item{data}{data in log odds}

\item{complete}{if TRUE, complete data log likelihood is considered (for
very large data sets, e.g. 1000 cells and 1000 E-genes)}
}
\value{
responsibilities as a kxl matrix (k components, l cells)
}
\description{
This function calculates the responsibilities
of each component for all cells from the expected log distribution of the
hidden data.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
resp <- getAffinity(result$probs, mw = result$mw, data = data)
}
\author{
Martin Pirkl
}
