% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{clustNEM}
\alias{clustNEM}
\title{Cluster NEM.}
\usage{
clustNEM(
  data,
  k = 2:10,
  cluster = NULL,
  starts = 1,
  logtype = 2,
  nem = TRUE,
  getprobspars = list(),
  getaffinitypars = list(),
  Rho = NULL,
  ...
)
}
\arguments{
\item{data}{data of log ratios with cells in columns and features in rows}

\item{k}{number of clusters to check}

\item{cluster}{given clustering has to correspond to the columns of data}

\item{starts}{number of random starts for the kmeans algorithm}

\item{logtype}{logarithm type of the data}

\item{nem}{if FALSE only clusters the data}

\item{getprobspars}{list of parameters for the getProbs function}

\item{getaffinitypars}{list of parameters for the getAffinity function}

\item{Rho}{perturbation matrix with dimensions nxl with n S-genes and
l samples; either as probabilities with the sum of probabilities for a
sample less or equal to 1 or discrete with 1s and 0s}

\item{...}{additional arguments for standard nem function}
}
\value{
family of nems; the first k list entries hold full information of
the standard nem search
\item{comp}{list of all adjacency matrices phi}
\item{mw}{vector of mixture weights}
\item{probs}{fake cell probabilities (see mw: mixture weights)}
}
\description{
This function clusters the data and performs standard nem on each cluster.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
resulst <- clustNEM(data, k = 2:3)
}
\author{
Martin Pirkl
}
