% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIndiv.R, R/plotIndiv.mint.R,
%   R/plotIndiv.pca.R, R/plotIndiv.pls.R, R/plotIndiv.sgcca.R
\name{plotIndiv}
\alias{plotIndiv}
\alias{plotIndiv.mint.pls}
\alias{plotIndiv.mint.spls}
\alias{plotIndiv.mint.plsda}
\alias{plotIndiv.mint.splsda}
\alias{plotIndiv.pca}
\alias{plotIndiv.mixo_pls}
\alias{plotIndiv.sgcca}
\alias{plotIndiv.rgcca}
\title{Plot of Individuals (Experimental Units)}
\usage{
plotIndiv(object, ...)

\method{plotIndiv}{mint.pls}(
  object,
  comp = NULL,
  rep.space = NULL,
  study = "global",
  layout = NULL,
  style = "ggplot2",
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  background = NULL,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  xlim = NULL,
  ylim = NULL,
  abline = FALSE,
  point.lwd = 1,
  cex,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{mint.spls}(
  object,
  comp = NULL,
  rep.space = NULL,
  study = "global",
  layout = NULL,
  style = "ggplot2",
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  background = NULL,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  xlim = NULL,
  ylim = NULL,
  abline = FALSE,
  point.lwd = 1,
  cex,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{mint.plsda}(
  object,
  comp = NULL,
  rep.space = NULL,
  study = "global",
  layout = NULL,
  style = "ggplot2",
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  background = NULL,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  xlim = NULL,
  ylim = NULL,
  abline = FALSE,
  point.lwd = 1,
  cex,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{mint.splsda}(
  object,
  comp = NULL,
  rep.space = NULL,
  study = "global",
  layout = NULL,
  style = "ggplot2",
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  background = NULL,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  xlim = NULL,
  ylim = NULL,
  abline = FALSE,
  point.lwd = 1,
  cex,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{pca}(
  object,
  comp = NULL,
  style = "ggplot2",
  ind.names = TRUE,
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  pch,
  title = NULL,
  legend = FALSE,
  legend.title.pch = "Legend",
  legend.title = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  Z.label = NULL,
  xlim = NULL,
  ylim = NULL,
  axes.box = "box",
  abline = FALSE,
  cex,
  alpha = 0.2,
  point.lwd = 1,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{mixo_pls}(
  object,
  comp = NULL,
  rep.space = NULL,
  style = "ggplot2",
  ind.names = TRUE,
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  background = NULL,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.title.pch = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  Z.label = NULL,
  abline = FALSE,
  xlim = NULL,
  ylim = NULL,
  axes.box = "box",
  cex,
  alpha = 0.2,
  point.lwd = 1,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{sgcca}(
  object,
  comp = NULL,
  blocks = NULL,
  style = "ggplot2",
  ind.names = TRUE,
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.title.pch = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  Z.label = NULL,
  abline = FALSE,
  xlim = NULL,
  ylim = NULL,
  axes.box = "box",
  cex,
  alpha = 0.2,
  point.lwd = 1,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)

\method{plotIndiv}{rgcca}(
  object,
  comp = NULL,
  blocks = NULL,
  style = "ggplot2",
  ind.names = TRUE,
  group,
  col,
  ellipse = FALSE,
  ellipse.level = 0.95,
  centroid = FALSE,
  star = FALSE,
  pch,
  title = NULL,
  subtitle,
  legend = FALSE,
  legend.title = "Legend",
  legend.title.pch = "Legend",
  legend.position = "right",
  X.label = NULL,
  Y.label = NULL,
  Z.label = NULL,
  abline = FALSE,
  xlim = NULL,
  ylim = NULL,
  axes.box = "box",
  cex,
  alpha = 0.2,
  point.lwd = 1,
  size.title = rel(2),
  size.subtitle = rel(1.5),
  size.xlabel = rel(1),
  size.ylabel = rel(1),
  size.axis = rel(0.8),
  size.legend = rel(1),
  size.legend.title = rel(1.1),
  ...
)
}
\arguments{
\item{object}{object of class inherited from any \pkg{mixOmics}: \code{PLS,
sPLS, PLS-DA, SPLS-DA, rCC, PCA, sPCA, IPCA, sIPCA, rGCCA, sGCCA, sGCCDA, MINT}}

\item{...}{Optional arguments or type par can be added with \code{style =
'graphics'}}

\item{comp}{integer vector of length two (or three to 3d). The components
that will be used on the horizontal and the vertical axis respectively to
project the individuals.}

\item{rep.space}{- only for objects of class \code{"pca", "plsda", "plsda", "rcc"}. Can be 
\code{"X-variate", "Y-variate", "XY-variate", "multi"}.}

\item{study}{- only for MINT models. Indicates whether to plot all studies together
\code{"global"} or separately \code{"all.partial"}. Default is "global".}

\item{layout}{layout parameter passed to mfrow. Only for MINT model and only 
used when \code{study} is "all.partial"}

\item{style}{argument to be set to either \code{'graphics'},
\code{'lattice'}, \code{'ggplot2'} or \code{'3d'} for a style of plotting.
Default set to 'ggplot2'. See details. \code{3d} is not available for MINT objects.}

\item{group}{factor indicating the group membership for each sample, useful
for colouring samples by groups, adding ellipses, centroids and stars.
Coded as default for the supervised methods \code{PLS-DA,
SPLS-DA,sGCCDA}, but needs to be input for the unsupervised methods
\code{PCA, sPCA, IPCA, sIPCA, PLS, sPLS, rCC, rGCCA, sGCCA}. 
Order of levels will reflect the order the groups appear in legends and 
correspond to the order of set colours in \code{col}.}

\item{col}{character (or symbol) color to be used. If \code{group} provided, should be a 
vector of the same length as groups, order of colours will be respected to correspond to 
order of \code{group} levels.}

\item{ellipse}{Logical indicating if ellipse plots should be plotted. See details.}

\item{ellipse.level}{Numerical value indicating the confidence level of
ellipse being plotted when \code{ellipse =TRUE} (i.e. the size of the
ellipse). The default is set to 0.95, for a 95\% region. See details.}

\item{centroid}{Logical indicating whether centroid points should be
plotted. See details.}

\item{star}{Logical indicating whether a star plot should be plotted, with
arrows starting from the centroid (see argument \code{centroid}, and ending
for each sample belonging to each group or outcome. See details.}

\item{background}{color the background by the predicted class, see
\code{\link{background.predict}}}

\item{pch}{value or vector, controls shape of points to be plotted. Can be used 
to control the shape of the points directly or to create a second group membership
and legend. See details.}

\item{title}{set of characters indicating the title plot.}

\item{subtitle}{subtitle for each plot, only used when several \code{block}
or \code{study} are plotted.}

\item{legend}{Logical. Whether the legend should be added. Default is FALSE.}

\item{legend.title}{title of the legend}

\item{legend.position}{position of the legend, one of "bottom", "left",
"top" and "right".}

\item{X.label}{x axis titles.}

\item{Y.label}{y axis titles.}

\item{xlim, ylim}{numeric list of vectors of length 2 and length
=length(blocks), giving the x and y coordinates ranges.}

\item{abline}{should the vertical and horizontal line through the center be
plotted? Default set to \code{FALSE}}

\item{point.lwd}{\code{lwd} of the points, used when \code{ind.names =
FALSE}}

\item{cex}{numeric character (or symbol) expansion, possibly vector.}

\item{size.title}{size of the title}

\item{size.subtitle}{size of the subtitle}

\item{size.xlabel}{size of xlabel}

\item{size.ylabel}{size of ylabel}

\item{size.axis}{size of the axis}

\item{size.legend}{size of the legend}

\item{size.legend.title}{size of the legend title}

\item{ind.names}{either a character vector of names for the individuals to
be plotted, or \code{FALSE} for no names. If \code{TRUE}, the row names of
the first (or second) data matrix is used as names (see Details). If `pch` is set this
will overwrite the names as shapes. Default is \code{TRUE}. 
Not avaliable for MINT objects.}

\item{legend.title.pch}{title of the second legend created by \code{pch}, if
any.}

\item{Z.label}{z axis titles (when style = '3d').}

\item{axes.box}{for style '3d', argument to be set to either \code{'axes'},
\code{'box'}, \code{'bbox'} or \code{'all'}, defining the shape of the box.}

\item{alpha}{Semi-transparent colors (0 < \code{'alpha'} < 1)}

\item{blocks}{- only for multiblock objects. Integer value or name(s) of block(s) to be plotted OR
"average" (averages the components from all blocks to produce a consensus plot) OR
"weighted.average" (weighted average of the components according to their correlation with the
outcome Y). See examples.}
}
\value{
none
}
\description{
This function provides scatter plots for individuals (observations)
representation in (s)(I)PCA, (r)CCA, (s)PLS(DA), multiblock (s)PLS(DA) and
MINT models.
}
\details{
\code{plotIndiv} method makes scatter plot for individuals representation
depending on the subspace of projection. Each point corresponds to an
individual.

If \code{ind.names=TRUE} and row names is \code{NULL}, then
\code{ind.names=1:n}, where \code{n} is the number of individuals. Also, if
\code{pch} is an input, then \code{ind.names} is set to FALSE as we do not
show both names and shapes.

The outputs of \code{"ellipse", "ellipse.level", "centroid", "star"} are:
1) based on the sample group membership (specified with the \code{group}) for unsupervised
models such as \code{PCA, sPCA, IPCA, sIPCA, PLS, sPLS, rCC, rGCCA,
sGCCA} or 2) based on the outcome \code{Y} for supervised models such as  \code{PLS-DA, SPLS-DA,sGCCDA}

#' In the specific case of a single `omics supervised model
(\code{\link{plsda}}, \code{\link{splsda}}), users can overlay prediction
results to sample plots in order to visualise the prediction areas of each
class, via the \code{background} input parameter. Note that this
functionality is only available for models with less than 2 components as
the surfaces obtained for higher order components cannot be projected onto a
2D representation in a meaningful way. For more details, see
\code{\link{background.predict}}

The \code{group} parameter is used to colour the samples by group membership, and by 
default the shape of samples will also correspond to these groups. Sample shapes can
be further customised using the \code{pch} parameter. This can be done in 3 ways:
1) If \code{pch} is one numeric value, shape of all points will be this. 
2) If \code{pch} is a vector of numeric values length equal to the number of groups 
set in \code{group}, then each group will have the given different shape. 
3) If \code{pch} is a character vector of length equal to the number of samples, then the
shape of each sample will correspond to this grouping, i.e. this allows users to visualise
second group membership. In case 3), the elements of the vector should be the names of the 
second group membership, as these will appear in the legend. The shapes of the second group
membership will be 1, 2, 3, etc by default, control of the shape is only possible by
reordering the levels of the second group membership.
See examples.

For customized plots (i.e. adding points, text), use the style = 'graphics'
(default is ggplot2).

Note: the ellipse options were borrowed from the \pkg{ellipse}.
}
\examples{
## 'pca' class - examples demonstrate how to control sample colours and shapes
# -----------------------------------------------------------------------------

# subset data and create model
data("srbct")
X <- srbct$gene[1:6, ]
rownames(X) <- c(paste0("Sample_", 1:6))
pca.obj <- pca(X, ncomp = 3)

primary_groups <- as.factor(c(rep("Group_1", 2), rep("Group_2", 2), rep("Group_3", 2)))
# [1] Group_1 Group_1 Group_2 Group_2 Group_3 Group_3
# Levels: Group_1 Group_2 Group_3
secondary_groups <- as.factor(c(rep("A", 3), rep("B", 2), rep("C", 1)))
# [1] A A A B B C
# Levels: A B C

# plot samples coloured by primary groups, show sample names
plotIndiv(pca.obj, ind.names = TRUE,
          group = primary_groups, legend = TRUE)

# plot samples coloured using custom colours by primary groups, show sample names
plotIndiv(pca.obj, ind.names = TRUE,
          group = primary_groups, legend = TRUE,
          col = c("red", "pink", "blue"))

# plot samples coloured by primary groups, by default shapes match primary groups
plotIndiv(pca.obj, ind.names = FALSE,
          group = primary_groups, legend = TRUE)

# plot samples coloured by primary groups, force all samples to have the same shape (2 = triangle)
plotIndiv(pca.obj, ind.names = FALSE,
          group = primary_groups, legend = TRUE,
          pch = 2)

# plot samples coloured by primary groups, use shapes to visualise secondary grouping
plotIndiv(pca.obj, ind.names = FALSE,
          group = primary_groups, legend = TRUE,
          pch = secondary_groups)

# plot samples coloured by primary groups, use shapes to visualise secondary grouping 
# and change order of secondary groups
plotIndiv(pca.obj, ind.names = FALSE,
          group = primary_groups, legend = TRUE,
          pch = factor(secondary_groups, levels = c("B", "C", "A")))


## 'rcc' class - examples demonstrate how to control rep.space
# ------------------------------------------------------------

# create model
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene
rcc.obj <- rcc(X, Y, ncomp = 3, lambda1 = 0.064, lambda2 = 0.008)

# plot samples, by default makes a panel plot for X and Y subspaces (multi)
plotIndiv(rcc.obj)

# plot samples only on X-variate subspace
plotIndiv(rcc.obj, rep.space = "X-variate")

# plot samples only on XY-variate subspace
plotIndiv(rcc.obj, rep.space = "XY-variate")


## 'spls' class - examples demonstrate how to add ellipses and centroids/stars on groups
# --------------------------------------------------------------------------------------

# create model
data(liver.toxicity)
X <- liver.toxicity$gene
Y <- liver.toxicity$clinic
spls.obj <- spls(X, Y, ncomp = 3, keepX = c(50, 50, 50),
                      keepY = c(10, 10, 10))

# plot samples with ellipse on groups
plotIndiv(spls.obj, group = liver.toxicity$treatment$Time.Group, ellipse = TRUE)

# plot samples with centroids on groups
plotIndiv(spls.obj, group = liver.toxicity$treatment$Time.Group, centroid = TRUE)

# plot samples with centroids and stars on groups
plotIndiv(spls.obj, group = liver.toxicity$treatment$Time.Group, centroid = TRUE, star = TRUE)



## 'splsda' class - examples demonstrate how to add ellipses and backgrounds based on 
# predicted classes
# ------------------------------------------------------------------------------------

# create model
data(breast.tumors)
X <- breast.tumors$gene.exp
Y <- breast.tumors$sample$treatment
splsda.obj <- splsda(X, Y,keepX=c(10,10),ncomp=2)

# plot samples with ellipse on groups, note groups do not have to be defined
plotIndiv(splsda.obj, ellipse = TRUE, ellipse.level = 0.8)

# plot samples with background coloured by predicted classes
background <- background.predict(splsda.obj, comp.predicted = 2, dist = "max.dist")
plotIndiv(splsda.obj, background = background)



## 'sgccda' class - examples demonstrate how to control which data blocks are plotted
# ------------------------------------------------------------------------------------

# create model
data(nutrimouse)
Y <- nutrimouse$diet
data <- list(gene = nutrimouse$gene, lipid = nutrimouse$lipid)
design <- matrix(c(0,1,0,1), ncol = 2, nrow = 2, byrow = TRUE)
sgccda.obj <- wrapper.sgccda(X = data, Y = Y, design = design, ncomp = 2,
                             keepX = list(gene = c(10,10), lipid = c(15,15)))

# plot samples, by default one data block for each plot
plotIndiv(sgccda.obj)

# plot samples for just the gene data block
plotIndiv(sgccda.obj, blocks = 1)
plotIndiv(sgccda.obj, blocks = "gene")

# plot samples by averaging components from all blocks
plotIndiv(sgccda.obj, blocks = "average")

# plot samples by the weighted average of the components according to their correlation 
# with Y
plotIndiv(sgccda.obj, blocks = "weighted.average")



## 'mint.splsda' class - examples demonstrate how to control which studies are plotted
# ------------------------------------------------------------------------------------

# create model
data(stemcells)
mint.obj <- mint.splsda(X = stemcells$gene, Y = stemcells$celltype, ncomp = 2, 
                  keepX = c(10, 5), study = stemcells$study)

# plot samples, by default samples are plotted together coloured by groups and pch by study
plotIndiv(mint.obj, legend = TRUE)

# plot samples separated by study, can control layout
plotIndiv(mint.obj, legend = TRUE, study = "all.partial")
plotIndiv(mint.obj, legend = TRUE, study = "all.partial", layout = c(1,1))
}
\seealso{
\code{\link{text}}, \code{\link{background.predict}},
\code{\link{points}} and http://mixOmics.org/graphics for more details.
}
\author{
Ignacio González, Benoit Gautier, Francois Bartolo, Florian Rohart,
Kim-Anh Lê Cao, Al J Abadi
}
\keyword{dplot}
\keyword{hplot}
\keyword{multivariate}
