% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_and_plot.R
\name{mitoTreePoint}
\alias{mitoTreePoint}
\title{Circular dotplot on mitochondrial gene set tree.}
\usage{
mitoTreePoint(
  data,
  database = "MitoCarta",
  pvalCutoff = 0.05,
  labsize = 3,
  max_point_size = 4,
  color = "p.adjust"
)
}
\arguments{
\item{data}{named list of the result from enrichMito or gseaMito.}

\item{database}{character string saying the database to use for the analysis.
Either one of "MitoCarta", "Reactome", "GO-CC" and "GO-BP".}

\item{pvalCutoff}{pvalue cutoff to select enriched gene sets}

\item{labsize}{label size}

\item{max_point_size}{max point size}

\item{color}{variable used to color enriched terms, e.g. 'pvalue', 
'p.adjust' or 'NES'.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
A circular dotplot of the mitochondrial enrichment results.
}
\examples{
data(ovse)

}
