% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_interaction_communities}
\alias{plot_interaction_communities}
\title{Plot marker interaction communities}
\usage{
plot_interaction_communities(misty.results, view, cutoff = 1)
}
\arguments{
\item{misty.results}{a results list generated by
\code{\link{collect_results}()}.}

\item{view}{abbreviated name of the view.}

\item{cutoff}{importance threshold. Importances below this value will
be colored white in the heatmap and considered as not relevant.}
}
\value{
The \code{misty.results} list (invisibly).
}
\description{
Identify and plot a graph of marker interaction communities.
}
\details{
The communities are identified using the Louvain algorithm. Communities can
be extracted only from views that have the same predictor and target markers.
}
\examples{
all.samples <- list.dirs("results", recursive = FALSE)

misty.results <- collect_results(all.samples)

misty.results \%>\%
  plot_interaction_communities("intra") \%>\%
  plot_interaction_communities("para.10")

misty.results \%>\%
  plot_interaction_communities("para.10", cutoff = 0.5)
}
\seealso{
\code{\link{collect_results}()} to generate a
    results list from raw results.

Other plotting functions: 
\code{\link{plot_contrast_heatmap}()},
\code{\link{plot_contrast_results}()},
\code{\link{plot_improvement_stats}()},
\code{\link{plot_interaction_heatmap}()},
\code{\link{plot_view_contributions}()}
}
\concept{plotting functions}
