% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_zeroinfl.R
\name{glm_zeroinfl}
\alias{glm_zeroinfl}
\title{Model functions for zero inflated model using either Poisson or Negative Binomial distributions.}
\usage{
glm_zeroinfl(dist = "poisson")
}
\arguments{
\item{dist}{either 'poisson' or 'negbin'}
}
\value{
structure containing functions \code{fit}, \code{coefficients},
        \code{aic}, \code{data}, \code{pterm}, \code{pmodel}, and a
        character string "glm_zeroinfl" in \code{model}.
}
\description{
Implements standardaized functions to fit the zero inflated model with
Poisson or Negative Binomial distribution, and to obtain coefficients,
pvalues, etc.
}
\examples{
x <- glm_zeroinfl("negbin")
}
