% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_cls.R
\name{net_cls,mina,ANY-method}
\alias{net_cls,mina,ANY-method}
\alias{net_cls,mina,character-method}
\title{Network clustering based on the sparsed adjacacency matrix.}
\usage{
\S4method{net_cls}{mina,ANY}(x, method, cutoff = 0.4, neg = FALSE, ...)

\S4method{net_cls}{mina,character}(x, method, cutoff = 0.4, neg = FALSE, ...)
}
\arguments{
\item{x}{An object of class `mina` with `adj` defined.}

\item{method}{The clustering method used.}

\item{cutoff}{The cutoff for the sparsed adjacacency matrix, default 0.4.}

\item{neg}{Whether to keep the negative edges, cannot be TRUE when using
`mcl` for clustering. Default FALSE.}

\item{...}{Additional parameters.}
}
\value{
x The same `mina` class with @cls added.
}
\description{
Network clustering based on the sparsed adjacacency matrix.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 1000)
maize <- fit_tabs(maize)
maize <- adj(maize, method = "spearman")
maize <- net_cls(maize, method = "mcl", cutoff = 0.4, neg = FALSE)
maize <- net_cls(maize, method = "ap", cutoff = 0.4, neg = FALSE)
}
