% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{getExperimentFrequencies}
\alias{getExperimentFrequencies}
\alias{getExperimentFrequencies.matrix}
\alias{getExperimentFrequencies.SummarizedExperiment}
\title{Calculate experiment's features frequencies}
\usage{
getExperimentFrequencies(
  experiment,
  pop_mul = NULL,
  carrier_frequency = FALSE,
  ref = NULL
)

\method{getExperimentFrequencies}{matrix}(
  experiment,
  pop_mul = NULL,
  carrier_frequency = FALSE,
  ref = NULL
)

\method{getExperimentFrequencies}{SummarizedExperiment}(
  experiment,
  pop_mul = NULL,
  carrier_frequency = FALSE,
  ref = NULL
)
}
\arguments{
\item{experiment}{Matrix or SummarizedExperiment object.}

\item{pop_mul}{Number by which number of samples should be multiplied to get
the population size.}

\item{carrier_frequency}{Logical flag indicating if carrier frequency should
be returned.}

\item{ref}{Wide format data frame with first column named "var" holding
features matching \code{experiment} and specific populations frequencies in
following columns. See \code{\link{getReferenceFrequencies}} for more
details.}
}
\value{
Data frame with each row holding specific variable, it's count and 
  frequency.
}
\description{
\code{getExperimentFrequencies} calculate features frequencies.
}
