% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getAlleleResolution}
\alias{getAlleleResolution}
\title{Infer HLA allele resolution}
\usage{
getAlleleResolution(allele)
}
\arguments{
\item{allele}{Character vector with HLA allele numbers.}
}
\value{
Integer vector specifying allele resolutions.
}
\description{
\code{getAlleleResolution} returns the resolution of input HLA allele
numbers.
}
\details{
HLA allele resolution can take the following values: 2, 4, 6, 8. See
\url{http://hla.alleles.org/nomenclature/naming.html} for more details.

\code{NA} values are accepted and returned as \code{NA}.
}
\examples{
allele <- c("A*01:01", "A*01:02")
getAlleleResolution(allele)

}
