% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{getAAFrequencies}
\alias{getAAFrequencies}
\title{Calculate amino acid frequencies}
\usage{
getAAFrequencies(aa_variation)
}
\arguments{
\item{aa_variation}{Amino acid variation data frame as returned by
\link{hlaToAAVariation}.}
}
\value{
Data frame with each row holding specific amino acid position, it's 
  count and frequency.
}
\description{
\code{getAAFrequencies} calculates amino acid frequencies in amino acid
data frame.
}
\details{
Both gene copies are taken into consideration for frequencies calculation,
\code{frequency = n / (2 * j)} where \code{n} is the number of amino acid
occurrences and \code{j} is the number of samples in \code{aa_variation}.
}
\examples{
aa_variation <- hlaToAAVariation(MiDAS_tut_HLA)
getAAFrequencies(aa_variation)

}
