% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare_abundance.R
\name{rare_abundance}
\alias{rare_abundance}
\title{Rare (Non-Core) Abundance Index}
\usage{
rare_abundance(
  x,
  detection = 0.1/100,
  prevalence = 50/100,
  include.lowest = FALSE
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1]). The
required prevalence is strictly greater by default. To include the
limit, set include.lowest to TRUE.}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs. FALSE by default.}
}
\value{
A vector of indices
}
\description{
Calculates the rare abundance community index.
}
\details{
This index gives the relative proportion of rare
species (ie. those that are not part of the core microbiota) in the
interval [0,1]. This is the complement (1-x) of the core abundance.
The rarity function provides the abundance of the least abundant taxa
within each sample, regardless of the population prevalence.
}
\examples{
data(dietswap)
d <- rare_abundance(dietswap, detection=0.1/100, prevalence=50/100)
}
\seealso{
core_abundance, rarity, diversity
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
