% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot Density}
\usage{
plot_density(
  x,
  variable = NULL,
  log10 = FALSE,
  adjust = 1,
  kernel = "gaussian",
  trim = FALSE,
  na.rm = FALSE,
  fill = "gray",
  tipping.point = NULL,
  xlim = NULL
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object or an OTU matrix
(samples x phylotypes)}

\item{variable}{OTU or metadata variable to visualize}

\item{log10}{Logical. Show log10 abundances or not.}

\item{adjust}{see stat_density}

\item{kernel}{see stat_density}

\item{trim}{see stat_density}

\item{na.rm}{see stat_density}

\item{fill}{Fill color}

\item{tipping.point}{Optional. Indicate critical point for abundance
variations to be highlighted.}

\item{xlim}{X axis limits}
}
\value{
A \code{\link{ggplot}} plot object.
}
\description{
Plot abundance density across samples for a given taxon.
}
\examples{
# Load gut microbiota data on 1006 western adults
# (see help(atlas1006) for references and details)
data(dietswap)
# Use compositional abundances instead of absolute signal
pseq.rel <- transform(dietswap, 'compositional')
# Population density for Dialister spp.; with log10 on the abundance (X)
# axis
library(ggplot2)
p <- plot_density(pseq.rel, variable='Dialister') + scale_x_log10()
}
\keyword{utilities}
