% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associate.R
\name{associate}
\alias{associate}
\alias{cross_correlate}
\title{Cross Correlation Wrapper}
\usage{
associate(
  x,
  y = NULL,
  method = "spearman",
  p.adj.threshold = Inf,
  cth = NULL,
  order = FALSE,
  n.signif = 0,
  mode = "table",
  p.adj.method = "fdr",
  verbose = FALSE,
  filter.self.correlations = FALSE
)
}
\arguments{
\item{x}{matrix (samples x features if annotation matrix)}

\item{y}{matrix (samples x features if cross-correlated with annotations)}

\item{method}{association method ('pearson', or 'spearman'
for continuous)}

\item{p.adj.threshold}{q-value threshold to include features}

\item{cth}{correlation threshold to include features}

\item{order}{order the results}

\item{n.signif}{minimum number of significant correlations for each 
element}

\item{mode}{Specify output format ('table' or 'matrix')}

\item{p.adj.method}{p-value multiple testing correction method. 
One of the methods in p.adjust 
function ('BH' and others; see help(p.adjust)). Default: 'fdr'}

\item{verbose}{verbose}

\item{filter.self.correlations}{Filter out correlations between 
identical items.}
}
\value{
List with cor, pval, pval.adjusted
}
\description{
Cross-correlate columns of the input matrices.
}
\details{
The p-values in the output table depend on the method. For the spearman
and pearson correlation values, the p-values are provided by the default
method in the cor.test function.
}
\examples{
data(peerj32)
d1 <- peerj32$microbes[1:20, 1:10]
d2 <- peerj32$lipids[1:20,1:10]
cc <- associate(d1, d2, method='pearson')
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
