% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{alpha}
\alias{alpha}
\title{Global Ecosystem State Variables}
\usage{
alpha(x, index = "all", zeroes = TRUE)
}
\arguments{
\item{x}{A species abundance vector, or matrix (taxa/features x samples)
with the absolute count data (no relative abundances), or
\code{\link{phyloseq-class}} object}

\item{index}{Default is ‘NULL’, meaning that all available indices
will be included. For specific options, see details.}

\item{zeroes}{Include zero counts in the diversity estimation.}
}
\value{
A data.frame of samples x alpha diversity indicators
}
\description{
Global indicators of the ecosystem state, including richness,
evenness, diversity, and other indicators
}
\details{
This function returns various indices of the ecosystem state.
The function is named alpha (global in some previous versions of this
package) as these indices can be viewed as measures of
alpha diversity. The function uses default choices for detection,
prevalence and other parameters for
simplicity and standardization. See the individual functions for more
options. All indicators from the richness, diversity, evenness,
dominance, and rarity functions are available. Some additional measures,
such as Chao1 and ACE are available via \code{\link{estimate_richness}}
function in the \pkg{phyloseq} package but not included here.
The index names are given the prefix richness_, evenness_, diversity_,
dominance_, or rarity_ in the output table to avoid confusion between
similarly named but different indices (e.g. Simpson diversity and Simpson
dominance). All parameters are set to their default. To experiment with
different parameterizations, see the more specific index functions
(richness, diversity, evenness, dominance, rarity).
}
\examples{
data(dietswap)
d <- alpha(dietswap, index='shannon')
# d <- alpha(dietswap, index='all')

}
\references{
See citation('microbiome')
}
\seealso{
dominance, rarity, phyloseq::estimate_richness
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
