% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{generateReport}
\alias{generateReport}
\title{Generates report}
\usage{
generateReport(
  rcode,
  filename = "report",
  dir = "out",
  title = "MicrobiomeExplorer Report",
  author = "",
  date = "`r format(Sys.time(), '\%d \%B, \%Y')`",
  data.source = "",
  output = c("html_document"),
  toc = TRUE,
  intro_text = NULL
)
}
\arguments{
\item{rcode}{A named list where each element corresponds to a different
analysis (Alpha diversity, Beta diversity). The name of the list is used to
denote the first part of the code chunks in each analysis section
(alpha, beta). Each element is itself a list of R commands corresponding to
a code chunk.}

\item{filename}{Name of output files. Default is "report".}

\item{dir}{Directory of output. Default is "out".}

\item{title}{Title of the report.}

\item{author}{Author of the report.}

\item{date}{Date of the report.}

\item{data.source}{R code used to obtain the dataset}

\item{output}{Output of Rmarkdown file. Options defined in global.R}

\item{toc}{Table of contents. Default is TRUE.}

\item{intro_text}{Introductory text to include with the report (optional)}
}
\value{
A character vector where each element is a line in the R script.
}
\description{
This function generates the pieces of the report, which includes the R
script, Rmarkdown file, and any Rmarkdown outputs.
}
\details{
Adapted from https://yihui.name/knitr/demo/stitch/
}
