% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_obs_functions.R
\name{mvrnorm_sim_obs}
\alias{mvrnorm_sim_obs}
\title{Simulate Microbiome Longitudinal Data from Multivariate Random Normal with
Observed Data}
\usage{
mvrnorm_sim_obs(
  id,
  time,
  group,
  ref,
  control_mean,
  sigma,
  rho,
  corr_str = c("ar1", "compound", "ind"),
  func_form = c("linear", "quadratic", "cubic", "M", "W", "L_up", "L_down"),
  beta,
  IP = NULL,
  dis_plot = FALSE,
  plot_trend = FALSE,
  zero_trunc = TRUE
)
}
\arguments{
\item{id}{vector of length \code{N} that identifies repeated measurements for
each unit}

\item{time}{vector of length \code{N} that determines when values will be
sampled for each unit}

\item{group}{factor vector with two levels indicating the group assignment
for each respective id}

\item{ref}{character value identifying which group value to treat as control
and which value to treat as treatment}

\item{control_mean}{numeric value specifying the mean value for control
subjects. all control subjects are assummed to have the same population mean
value.}

\item{sigma}{numeric value specifying the global population standard
deviation for both control and treated individuals.}

\item{rho}{value for the correlation parameter. must be between [0, 1].
see \code{\link[microbiomeDASim]{mvrnorm_corr_gen}} for details.}

\item{corr_str}{correlation structure selected. see
\code{\link[microbiomeDASim]{mvrnorm_corr_gen}} for details.}

\item{func_form}{character value specifying the functional form for the
longitduinal mean trend. see \code{\link[microbiomeDASim]{mean_trend}}
for details.}

\item{beta}{vector value specifying the parameters for the differential
abundance function. see \code{\link[microbiomeDASim]{mean_trend}} for
details.}

\item{IP}{vector specifying any inflection points. depends on the type of
functional form specified. see \code{\link[microbiomeDASim]{mean_trend}} for
details. by default this is set to NULL.}

\item{dis_plot}{logical argument on whether to plot the simulated data or
not. by default plotting is turned off.}

\item{plot_trend}{specifies whether to plot the true mean trend. see
\code{\link[microbiomeDASim]{mean_trend}} for details.}

\item{zero_trunc}{logical indicator designating whether simulated outcomes
should be zero truncated. default is set to TRUE}
}
\value{
This function returns a list with the following objects:

\code{df} - data.frame object with complete outcome \code{Y}, subject ID,
time, group, and outcome with missing data

\code{Y} - vector of complete outcome

\code{Mu} - vector of complete mean specifications used during simulation

\code{Sigma} - block diagonal symmetric matrix of complete data used during
simulation

\code{N} - total number of observations
}
\description{
This function is used in the
\code{\link[microbiomeDASim]{gen_norm_microbiome_obs}} call.
}
\examples{
set.seed(011520)
id_list <- lapply(seq_len(30), function(i){
obs <- sample(seq_len(10), size=1)
id_rep <- rep(i, obs)
})

time_interval <- c(0, 10)
time_list <- lapply(id_list, function(x){
time_len <- length(x)
times <- runif(time_len, min=time_interval[1], max=time_interval[2])
times <- times[order(times)]
})

group_list <- lapply(id_list, function(x){
group_len <- length(x)
tx_ind <- sample(seq_len(2), 1)
tx_group <- ifelse(tx_ind==1, "Control", "Treatment")
groups <- rep(tx_group, group_len)
})
id <- unlist(id_list)
group <- factor(unlist(group_list), levels = c("Control", "Treatment"))
time <- unlist(time_list)

# N=173 total repeated measurements
length(id)

# 15 control and 15 treated subjects
table(group[unique(id)])

# control times
ct <- unlist(lapply(unique(id[group=="Control"]), function(x){
length(id[id==x])
}))

#treatment times
tt <- unlist(lapply(unique(id[group=="Treatment"]), function(x){
length(id[id==x])
}))

# on average the treatment group has one more observation than control
mean(ct)
mean(tt)

mvrnorm_sim_obs(id=id, time=time, group=group, ref="Control", control_mean=2,
               sigma=1, rho=0.7, corr_str="compound", func_form="L_up",
               beta=1, IP=5, plot_trend=TRUE, dis_plot=TRUE, zero_trunc=TRUE)

}
