% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotColTile.R
\name{plotColTile}
\alias{plotColTile}
\alias{plotRowTile}
\alias{plotColTile,SummarizedExperiment-method}
\alias{plotRowTile,SummarizedExperiment-method}
\title{Plot factor data as tiles}
\usage{
plotColTile(object, x, y, ...)

plotRowTile(object, x, y, ...)

\S4method{plotColTile}{SummarizedExperiment}(object, x, y, ...)

\S4method{plotRowTile}{SummarizedExperiment}(object, x, y, ...)
}
\arguments{
\item{object}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{x}{\code{Character scalar}. Specifies the column-level metadata field
to show on the x-axis.
Alternatively, an \link{AsIs} vector or data.frame, see
\code{?\link{retrieveFeatureInfo}} or \code{?\link{retrieveCellInfo}}. Must
result in a returned \code{character} or \code{factor} vector.}

\item{y}{\code{Character scalar}. Specifies the column-level metadata to
show on the y-axis.
Alternatively, an \link{AsIs} vector or data.frame, see
\code{?\link{retrieveFeatureInfo}} or \code{?\link{retrieveCellInfo}}. Must
result in a returned \code{character} or \code{factor} vector.}

\item{...}{additional arguments for plotting. See
\code{\link{mia-plot-args}} for more details i.e. call
\code{help("mia-plot-args")}}
}
\value{
A \code{ggplot2} object or \code{plotly} object, if more than one
\code{prevalences} was defined.
}
\description{
Relative relations of two grouping can be visualized by plotting tiles with
relative sizes. \code{plotColTile} and \code{plotRowTile} can be used for
this.
}
\examples{
data(GlobalPatterns)
se <- GlobalPatterns
plotColTile(se,"SampleType","Primer")
}
