% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getBimodality.R
\name{getBimodality}
\alias{getBimodality}
\alias{addBimodality}
\alias{addBimodality,SummarizedExperiment-method}
\alias{getBimodality,SummarizedExperiment-method}
\title{Calculate coefficient of bimodality.}
\usage{
getBimodality(x, ...)

addBimodality(x, ...)

\S4method{addBimodality}{SummarizedExperiment}(x, name = "bimodality", ...)

\S4method{getBimodality}{SummarizedExperiment}(x, assay.type = "counts", ...)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{additional arguments.
\itemize{
\item \code{group}: \code{Character scalar}. Specifies a name of the column
from \code{colData} that identifies the grouping of the samples.
(Default: \code{NULL})
}}

\item{name}{\code{Character scalar}. Specifies a column name for storing
bimodality results. (Default: \code{"bimodality"})}

\item{assay.type}{\code{Character scalar}. Specifies which assay values are
used in the dissimilarity estimation. (Default: \code{"counts"})}
}
\value{
\code{DataFrame} or \code{x} with results added to its \code{rowData}.
}
\description{
This function calculates coefficient of bimodality for each taxa.
}
\details{
This function calculates coefficient of bimodality for each taxa. If the
dataset includes grouping, for instance, individual systems or patients,
the coefficient is calculated for each group separately.

The coefficient of bimodality measures whether a taxon has bimodal abundance.
For instance, certain taxon can be high-abundant in some timepoints while
in others it might be rare. The coefficient can help to determine these
taxa.

The coefficient of bimodality (b) is defined as follows:

\deqn{b = \frac{1+skewness^{2}}{kurtosis+3}}

where skewness is calculated as follows

\deqn{skewness = \frac{\sum_{i=1}^{n}(x_{i}-\overline{x})^{3}/n}{
\sum_{i=1}^{n}(x_{i}-\overline{x})^{2}/n]^{3/2}}}

and kurtosis as follows

\deqn{kurtosis = \frac{\sum_{i=1}^{n}(x_{i}-\overline{x})^{4}/n}{
(\sum_{i=1}^{n}(x_{i}-\overline{x})^{2}/n)^{2}}}

The coefficient ranges from 0-1, where 1 means high bimodality. The
coefficient was introduced in the paper Shade A et al. 2014, where they used
bimodality and abundance to determine conditionally rare taxa (CRT).
}
\examples{
library(miaTime)

data(SilvermanAGutData)
tse <- SilvermanAGutData

# In this example, we are only interested on vessel 1.
tse <- tse[, tse[["Vessel"]] == 1]
tse <- transformAssay(tse, method = "relabundance")

# Calculate bimodality
b <- getBimodality(tse)
# Determine taxa with high bimodality
bimodal_taxa <- names(b)[ which(b[[1]] > 0.95) ]

# Determine taxa with abundance > 0.5\%
abundant <- getAbundant(
    tse, assay.type = "relabundance", abundant.th = 0.5/100)

# The detected CRT
crt <- intersect(bimodal_taxa, abundant)
head(crt)

}
\references{
Shade A, et al. (2014)
Conditionally Rare Taxa Disproportionately Contribute to Temporal Changes in
Microbial Diversity. doi: 10.1128/mbio.01371-14
}
\seealso{
\code{\link[mia:getAbundant]{mia::getConditionallyLowAbundant()}}
}
