% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomE.R
\name{randomE}
\alias{randomE}
\title{Generate random efficiency matrix}
\usage{
randomE(
  n_species,
  n_resources,
  names_species = NULL,
  names_resources = NULL,
  mean_consumption = n_resources/4,
  mean_production = n_resources/6,
  maintenance = 0.5,
  trophic_levels = NULL,
  trophic_preferences = NULL,
  exact = FALSE
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{n_resources}{Integer: number of resources}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{names_resources}{Character: names of resources. If NULL,
\code{paste0("res", seq_len(n_resources))} is used.}

\item{mean_consumption}{\code{Numeric scalar}. Specifies the mean number
of resources consumed by each species drawn from a poisson distribution
(Default: \code{n_resources/4})}

\item{mean_production}{\code{Numeric scalar}. Specifies the mean number
of resources produced by each species drawn from a poisson distribution
(Default: \code{n_resources/6})}

\item{maintenance}{\code{Numeric scalar}. Specifies the proportion of
resources that cannot be converted into products between 0~1 the
proportion of resources used to maintain the living of microorganisms.
0 means all the resources will be used for the reproduction of
microorganisms, and 1 means all the resources would be used to maintain
the living of organisms and no resources would be left for their
growth(reproduction). (Default: \code{0.5})}

\item{trophic_levels}{\code{Integer scalar}. Indicates the number of
species in microbial trophic levels. If NULL, by default, microbial
trophic levels would not be considered. (Default: \code{NULL})}

\item{trophic_preferences}{\code{List}. Indicates the preferred resources
and productions of each trophic level. Positive values indicate the
consumption of resources, whilst negatives indicate that the species
would produce the resource. (Default: \code{NULL})}

\item{exact}{\code{Logical scalar}. Whether to set the number of
consumption/production to be exact as mean_consumption/mean_production
or to set them using a Poisson distribution. (Default: \code{FALSE})
If \code{length(trophic_preferences)} is smaller than \code{length(trophic_levels)},
then NULL values would be appended to lower trophic levels.
If NULL, by default, the consumption preference will be defined randomly.
(Default: \code{trophic_preferences = NULL})}
}
\value{
\code{randomE} returns a matrix E with dimensions (n_species x n_resources),
and each row represents a species.
}
\description{
Generate random efficiency matrix for consumer resource model from Dirichlet
distribution, where positive efficiencies indicate the consumption of resources,
whilst negatives indicate that the species would produce the resource.
}
\examples{
# example with minimum parameters
ExampleEfficiencyMatrix <- randomE(n_species = 5, n_resources = 12)

# examples with specific parameters
ExampleEfficiencyMatrix <- randomE(
    n_species = 3, n_resources = 6,
    names_species = letters[1:3],
    names_resources = paste0("res", LETTERS[1:6]),
    mean_consumption = 3, mean_production = 1
)
ExampleEfficiencyMatrix <- randomE(
    n_species = 3, n_resources = 6,
    maintenance = 0.4
)
ExampleEfficiencyMatrix <- randomE(
    n_species = 3, n_resources = 6,
    mean_consumption = 3, mean_production = 1, maintenance = 0.4
)

# examples with microbial trophic levels
ExampleEfficiencyMatrix <- randomE(
    n_species = 10, n_resources = 15,
    trophic_levels = c(6, 3, 1),
    trophic_preferences = list(
        c(rep(1, 5), rep(-1, 5), rep(0, 5)),
        c(rep(0, 5), rep(1, 5), rep(-1, 5)),
        c(rep(0, 10), rep(1, 5))
    )
)
ExampleEfficiencyMatrix <- randomE(
    n_species = 10, n_resources = 15,
    trophic_levels = c(6, 3, 1),
    trophic_preferences = list(c(rep(1, 5), rep(-1, 5), rep(0, 5)), NULL, NULL)
)
ExampleEfficiencyMatrix <- randomE(
    n_species = 10, n_resources = 15,
    trophic_levels = c(6, 3, 1)
)

}
