% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_ProNet}
\alias{module_ProNet}
\title{module_ProNet}
\usage{
module_ProNet(
  ceRExp,
  mRExp = NULL,
  cor.method = "pearson",
  pos.p.value.cutoff = 0.01,
  cluster.method = "MCL",
  num.ModuleceRs = 2,
  num.ModulemRs = 2
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{cor.method}{The method of calculating correlation selected, 
including 'pearson' (default), 'kendall', 'spearman'.}

\item{pos.p.value.cutoff}{The significant p-value cutoff of 
positive correlation}

\item{cluster.method}{The clustering method selected in 
\pkg{ProNet} package, including 'FN', 'MCL' (default), 
'LINKCOMM', 'MCODE'.}

\item{num.ModuleceRs}{The minimum number of ceRNAs in each module.}

\item{num.ModulemRs}{The minimum number of mRNAs in each module.}
}
\value{
GeneSetCollection object: a list of module genes.
}
\description{
Identification of gene modules from matched ceRNA and mRNA 
expression data or single gene expression data using ProNet package
}
\examples{
data(BRCASampleData)
modulegenes_ProNet <- module_ProNet(ceRExp[, seq_len(10)],
    mRExp[, seq_len(10)])

}
\references{
Clauset A, Newman ME, Moore C. Finding community 
structure in very large networks. Phys Rev E Stat Nonlin Soft 
Matter Phys., 2004, 70(6 Pt 2):066111.

Enright AJ, Van Dongen S, Ouzounis CA. An efficient 
algorithm for large-scale detection of protein families. 
Nucleic Acids Res., 2002, 30(7):1575-84.

Kalinka AT, Tomancak P. linkcomm: an R package 
for the generation, visualization, and analysis of link 
communities in networks of arbitrary size and type. 
Bioinformatics, 2011, 27(14):2011-2.

Bader GD, Hogue CW. An automated method for 
finding molecular complexes in large protein interaction 
networks. BMC Bioinformatics, 2003, 4:2.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
