% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_NMF}
\alias{module_NMF}
\title{module_NMF}
\usage{
module_NMF(
  ceRExp,
  mRExp = NULL,
  NMF.algorithm = "brunet",
  num.modules = 10,
  num.ModuleceRs = 2,
  num.ModulemRs = 2
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{NMF.algorithm}{Specification of the NMF algorithm, 
including 'brunet' (default), 'Frobenius', 'KL', 'lee', 'nsNMF', 
'offset', 'siNMF', 'snmf/l', 'snmf/r'.}

\item{num.modules}{The number of modules to be identified.}

\item{num.ModuleceRs}{The minimum number of ceRNAs in each module.}

\item{num.ModulemRs}{The minimum number of mRNAs in each module.}
}
\value{
GeneSetCollection object: a list of module genes.
}
\description{
Identification of gene modules from matched ceRNA and mRNA 
expression data or single gene expression data using NMF package
}
\examples{
data(BRCASampleData)
# Reimport NMF package to avoid conflicts with DelayedArray package
library(NMF)
modulegenes_NMF <- module_NMF(ceRExp[, seq_len(10)],
    mRExp[, seq_len(10)])

}
\references{
Gaujoux R, Seoighe C. A flexible R package for 
nonnegative matrix factorization. BMC Bioinformatics. 2010, 11:367.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
