% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFiltering.R
\name{plotFiltering}
\alias{plotFiltering}
\title{plotFiltering}
\usage{
plotFiltering(
sce,
model = NULL,
posterior_cutoff = 0.75,
keep_all_below_boundary = TRUE,
enforce_left_cutoff = TRUE,
palette = c("#999999", "#E69F00"),
detected = "detected",
subsets_mito_percent = "subsets_mito_percent"
)
}
\arguments{
\item{sce}{(SingleCellExperiment) Input data object.}

\item{model}{(flexmix) Output of mixtureModel function, which should be
explicitly called first to ensure stability of model parameters.
Default = NULL.}

\item{posterior_cutoff}{(numeric) The posterior probability of a cell being
part of the compromised distribution, a number between 0 and 1. Any cells
below the appointed cutoff will be marked to keep.
Default = 0.75}

\item{keep_all_below_boundary}{(boolean) Ensures that no cells below the
intact cell distribution are removed. This should almost always be set
to true.
Default = TRUE}

\item{enforce_left_cutoff}{(boolean) Prevents a U-shape in the filtering 
plot. Identifies the cell with the lowest mitochondrial fraction that is
set to be discarded, it ensures that no cells with lower library 
complexity (further left) and higher mitochondrial percentage (further up)
than it are kept.
Default = TRUE}

\item{palette}{(character) Color palette. A vector of length two containing
custom colors.
Default = c("#999999", "#E69F00").}

\item{detected}{(character) Column name in sce giving the number of unique
genes detected per cell. This name is inherited by default from scater's
addPerCellQC() function.}

\item{subsets_mito_percent}{(character) Column name in sce giving the
percent of reads mapping to mitochondrial genes. This name is inherited
from scater's addPerCellQC() function, provided the subset "mito" with
names of all mitochondrial genes is passed in. See examples for details.}
}
\value{
Returns a ggplot object. Additional plot elements can be added as
ggplot elements (e.g. title, customized formatting, etc).
}
\description{
Function to plot which cells will be kept and removed given their posterior
probability of belonging to the compromised distribution.
}
\examples{
library(scRNAseq)
library(scater)
sce <- ZeiselBrainData()
mt_genes <- grepl("^mt-",  rownames(sce))
feature_ctrls <- list(mito = rownames(sce)[mt_genes])
sce <- addPerCellQC(sce, subsets = feature_ctrls)
model <- mixtureModel(sce)
plotFiltering(sce, model)
}
