#' PROGRESS cohor data
#'
#' A dataset containing data from the PROGRESS (Programming
#' Research in Obesity, Growth, Environment and Social Stressors) cohort
#'
#' @description
#' The PROGRESS cohort data is available in the additional file 8 of :
#' Knight, A.K., Craig, J.M., Theda, C. et al.
#' An epigenetic clock for gestational age at birth based on blood
#' methylation data.
#' Genome Biol 17, 206 (2016).
#' https://doi.org/10.1186/s13059-016-1068-z
#'
#' @docType data
#' @usage data(progress_data)
#' @format A data frame with 148 obs. and 151 variables
#'
#' @examples
#' data(progress_data)
"progress_data"

#' PROGRESS cohort variables
#'
#' A dataset containing data from the PROGRESS (Programming
#' Research in Obesity, Growth, Environment and Social Stressors) cohort
#'
#'
#' @description
#' The PROGRESS cohort data is available in the additional file 8 of :
#' Knight, A.K., Craig, J.M., Theda, C. et al.
#' An epigenetic clock for gestational age at birth based on blood
#' methylation data.
#' Genome Biol 17, 206 (2016).
#' https://doi.org/10.1186/s13059-016-1068-z
#' @docType data
#' @usage data(progress_vars)
#' @format A data frame with 150 obs. and 3 variables
#' @examples
#' data(progress_vars)
"progress_vars"
