% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorganize.R, R/methylDBFunctions.R
\docType{methods}
\name{reorganize}
\alias{reorganize}
\alias{reorganize,methylBase-method}
\alias{reorganize,methylRawList-method}
\alias{reorganize,methylRawListDB-method}
\alias{reorganize,methylBaseDB-method}
\title{Reorganize methylKit objects by creating new objects from subset of samples}
\usage{
reorganize(
  methylObj,
  sample.ids,
  treatment,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{reorganize}{methylBase}(
  methylObj,
  sample.ids,
  treatment,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{reorganize}{methylRawList}(
  methylObj,
  sample.ids,
  treatment,
  chunk.size = 1e+06,
  save.db = FALSE,
  ...
)

\S4method{reorganize}{methylRawListDB}(
  methylObj,
  sample.ids,
  treatment,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)

\S4method{reorganize}{methylBaseDB}(
  methylObj,
  sample.ids,
  treatment,
  chunk.size = 1e+06,
  save.db = TRUE,
  ...
)
}
\arguments{
\item{methylObj}{a \code{methylRawList}, \code{methylRawListDB}, 
\code{methylBase} or \code{methylBaseDB} object}

\item{sample.ids}{a vector for sample.ids to be subset. Order is 
important and the order should be similar to treatment. sample.ids 
should be
a subset or reordered version of sample ids in the input object.}

\item{treatment}{treatment vector, should be same length as sample.ids vector}

\item{chunk.size}{Number of rows to be taken as a chunk for processing the 
\code{methylBaseDB} or \code{methylRawListDB} objects, default: 1e6}

\item{save.db}{A Logical to decide whether the resulting object should be 
saved as flat file database or not, default: explained in Details sections}

\item{...}{optional Arguments used when save.db is TRUE
 
 \code{suffix}
       A character string to append to the name of the output 
       flat file database, 
       only used if save.db is true, default actions: 
       For \dQuote{methylBase}: The default suffix is a 13-character random string appended 
       to the fixed prefix \dQuote{methylBase}, e.g. 
       \dQuote{methylBase_16d3047c1a254.txt.bgz}. 
       For \dQuote{methylRawList}: ignored.
       
 \code{dbdir} 
       The directory where flat file database(s) should be 
       stored, defaults
       to getwd(), working directory for newly stored databases
       and to same directory for already existing database
       
\code{dbtype}
       The type of the flat file database, currently only option 
      "tabix"}
}
\value{
returns a \code{methylRawList}, \code{methylRawListDB}, 
\code{methylBase} or \code{methylBaseDB} object depending on the input object
}
\description{
The function creates a new  \code{methylRawList}, \code{methylRawListDB}, 
\code{methylBase} or \code{methylBaseDB} 
object by selecting a subset of samples from the input object, which is 
a \code{methylRawList} or \code{methylBase} object. You can use the function
 to partition a large methylRawList or methylBase object
to smaller object based on sample ids or when you want to reorder samples
 and/or give a new treatmet vector.
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with 
\code{methylBaseDB} or \code{methylRawListDB} objects, 
as they are read in chunk by chunk to enable processing large-sized 
objects which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for most systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the 
\code{chunk.size}.

The parameter \code{save.db} is per default TRUE for methylDB objects as 
\code{methylBaseDB} and \code{methylRawListDB}, 
while being per default FALSE for \code{methylBase} and 
\code{methylRawList}. If you wish to save the result of an 
in-memory-calculation as flat file database or if the size of the 
database allows the calculation in-memory, 
then you might want to change the value of this parameter.
}

\examples{
# this is a list of example files, ships with the package
file.list=list( system.file("extdata", "test1.myCpG.txt", package = "methylKit"),
               system.file("extdata", "test2.myCpG.txt", package = "methylKit"),
               system.file("extdata", "control1.myCpG.txt", package = "methylKit"),
               system.file("extdata", "control2.myCpG.txt", package = "methylKit") )


# read the files to a methylRawList object: myobj
myobj=methRead( file.list,
          sample.id=list("test1","test2","ctrl1","ctrl2"),
          assembly="hg18",pipeline="amp",treatment=c(1,1,0,0))
meth=unite(myobj,destrand=TRUE)

# get samples named "test1" and "ctrl2" from myobj and create a new methylRawList object
myobj2=reorganize(myobj,sample.ids=c("test1","ctrl2"),treatment=c(1,0) )

# # get samples named "test1" and "ctrl2" from meth and create a new methylBase object
meth2 =reorganize(meth,sample.ids=c("test1","ctrl2"),treatment=c(1,0) )


}
