% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{extract}
\alias{extract}
\alias{[,methylRaw,ANY,ANY,ANY-method}
\alias{extract,methylRaw,ANY-method}
\alias{[,methylBase,ANY,ANY,ANY-method}
\alias{extract,methylBase,ANY-method}
\alias{[,methylDiff,ANY,ANY,ANY-method}
\alias{extract,methylDiff,ANY-method}
\alias{[,methylRawDB,ANY,ANY,ANY-method}
\alias{extract,methylRawDB,ANY-method}
\alias{[,methylBaseDB,ANY,ANY,ANY-method}
\alias{extract,methylBaseDB,ANY-method}
\alias{[,methylDiffDB,ANY,ANY,ANY-method}
\alias{extract,methylDiffDB,ANY-method}
\title{extract parts of methylRaw,methylRawDB,methylBase,methylBaseDB and methylDiff data}
\usage{
\S4method{[}{methylRaw,ANY,ANY,ANY}(x, i, j)

\S4method{[}{methylBase,ANY,ANY,ANY}(x, i, j)

\S4method{[}{methylDiff,ANY,ANY,ANY}(x, i, j)

\S4method{[}{methylRawDB,ANY,ANY,ANY}(x, i, j)

\S4method{[}{methylBaseDB,ANY,ANY,ANY}(x, i, j)

\S4method{[}{methylDiffDB,ANY,ANY,ANY}(x, i, j)
}
\arguments{
\item{x}{an \code{\link{methylBase}},\code{\link{methylBaseDB}},
\code{\link{methylRaw}},\code{\link{methylRawDB}} or 
         \code{\link{methylDiff}} object}

\item{i}{a numeric or logical vector. This vector corresponds to bases or 
regions contained in \code{methylKit} objects.The vector is used to 
subset the data.}

\item{j}{This argument can not be used for the extraction of columns.
As unintentional extraction of the columns will cause an error in
the downstream analysis. Using this argument will cause an error.
 Use \code{\link{getData}} to access the data part of 
 the objects.}
}
\description{
The function extracts part of the data and returns a new object.
}
\examples{
data(methylKit)

# selects first hundred rows, returns a methylRaw object
subset1=methylRawList.obj[[1]][1:100] 

# selects first hundred rows, returns a methylBase object
subset2=methylBase.obj[1:100,] 

# selects first hundred rows, returns a methylDiff object
subset3=methylDiff.obj[1:100,] 

# This will get chromomsomes, will return a factor
# That means the resulting object will ceases to be a methylKit object
chrs=methylDiff.obj[[2]]


}
