% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{plotConvergenceGraph}
\alias{plotConvergenceGraph}
\title{Generate a graph showing the convergence for a permutation analysis}
\usage{
plotConvergenceGraph(dataFrameConvergence)
}
\arguments{
\item{dataFrameConvergence}{a \code{data.frame} containing the
significant levels at different number of cycles (total number of
permuted data analysed).  The
\code{data.frame} must have 6 columns : "NBR_PERMUTATIONS", "ELEMENT".
"ANALYSIS", "POSITION", "TYPE" and "SIGNIFICANT_LEVEL". The "ELEMENT" can
be either "SITES" or "TILES". The "TYPE" can be either "HYPER" or "HYPO".}
}
\value{
a \code{ggplot} object.
}
\description{
Generate a graph showing the convergence for a permutation
analysis using observed and permuted results.
}
\examples{

## Get the name of the directory where files are stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Extract convergenc information for F1 and F2 and F3
data <- loadConvergenceData(analysisResultsDir = filesDir,
    permutationResultsDir = filesDir, type = "sites", inter = "iAll",
    position = 1, by = 1)

## Create convergence graph
plotConvergenceGraph(data)

}
\author{
Astrid Deschenes, Pascal Belleau
}
