% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylglm.R
\name{methylglm}
\alias{methylglm}
\title{Implement logistic regression adjusting
for number of probes in enrichment analysis}
\usage{
methylglm(cpg.pval, array.type = "450K", FullAnnot = NULL,
  group = "all", GS.list = NULL, GS.idtype = "SYMBOL",
  GS.type = "GO", minsize = 100, maxsize = 500, parallel = FALSE,
  BPPARAM = bpparam())
}
\arguments{
\item{cpg.pval}{A named vector containing p-values of differential
methylation test. Names should be CpG IDs.}

\item{array.type}{A string. Either "450K" or "EPIC". Default is "450K".
This argument will be ignored if FullAnnot is provided.}

\item{FullAnnot}{A data frame provided by prepareAnnot function.
Default is NULL.}

\item{group}{A string. "all", "body", "promoter1" or "promoter2". 
Default is "all". If group = "body", only CpGs on gene body will be 
considered in methylglm. If group = "promoter1" or group = "promoter2", 
only CpGs on promoters will be considered. Here is the definition of "body", 
"promoter1" and "promoter2" according to the annotation in 
IlluminaHumanMethylation450kanno.ilmn12.hg19 or 
IlluminaHumanMethylationEPICanno.ilm10b4.hg19. 
\itemize{
  \item body: CpGs whose gene group correspond to "Body" or "1stExon" 
  \item promoter1: CpGs whose gene group correspond to "TSS1500" or "TSS200"
  \item promoter2: CpGs whose gene group correspond to "TSS1500", "TSS200", 
  "1stExon", or "5'UTR". 
}
If group = "all", all CpGs are considered regardless of their gene group.}

\item{GS.list}{A list. Default is NULL. If there is no input list,
Gene Ontology is used. Entry names are gene sets names, and elements
correpond to genes that gene sets contain.}

\item{GS.idtype}{A string. "SYMBOL", "ENSEMBL", "ENTREZID" or "REFSEQ".
Default is "SYMBOL"}

\item{GS.type}{A string. "GO", "KEGG", or "Reactome". Default is "GO"}

\item{minsize}{An integer. If the number of genes in a gene set is
less than this integer, this gene set is not tested. Default is 100.}

\item{maxsize}{An integer. If the number of genes in a gene set is greater
than this integer, this gene set is not tested. Default is 500.}

\item{parallel}{either TRUE or FALSE indicating whether parallel should be
used. Default is FALSE}

\item{BPPARAM}{an argument provided to \code{\link{bplapply}}. See
\code{\link[BiocParallel]{register}} for details.}
}
\value{
A data frame contains gene set tests results.
}
\description{
This function implements logistic regression adjusting
for number of probes in enrichment analysis.
}
\details{
The implementation of this function is modified from goglm
function in GOglm package.
}
\examples{
data(CpG2Genetoy)
data(cpgtoy)
data(GSlisttoy)
GS.list = GS.list[1:10]
FullAnnot = prepareAnnot(CpG2Gene)
res = methylglm(cpg.pval = cpg.pval, FullAnnot = FullAnnot,
GS.list = GS.list, GS.idtype = "SYMBOL")
head(res)
}
\references{
Mi G, Di Y, Emerson S, Cumbie JS and Chang JH (2012)
Length bias correction in Gene Ontology enrichment analysis using
logistic regression. PLOS ONE, 7(10): e46128

Phipson, B., Maksimovic, J., and Oshlack, A. (2015).
missMethyl: an R package for analysing methylation data from Illuminas
HumanMethylation450 platform. Bioinformatics, btv560.

Carlson M (2017). org.Hs.eg.db: Genome wide annotation for
Human. R package version 3.5.0.
}
