% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methyLImp2.R
\name{methyLImp2_internal}
\alias{methyLImp2_internal}
\title{Impute missing values in methylation dataset}
\usage{
methyLImp2_internal(
  dat,
  min,
  max,
  skip_imputation_ids,
  minibatch_frac,
  minibatch_reps
)
}
\arguments{
\item{dat}{a numeric data matrix with missing values, 
with samples in rows and variables (probes) in columns.}

\item{min}{a number, minimum value for bounded-range variables. 
Default is 0 (we assume beta-value representation of the methylation data). 
Can be user provided in case of other types of data.}

\item{max}{a number, maximum value for bounded-range variables. 
Default is 1 (we assume beta-value representation of the methylation data). 
Can be user provided in case of other types of data.}

\item{skip_imputation_ids}{a numeric vector of ids of the columns with NAs for which 
\emph{not} to perform the imputation. If \code{NULL}, all columns are considered.}

\item{minibatch_frac}{a number, what percentage of samples to use for 
mini-batch computation. The default is 1 (i.e., 100\% of samples are used, 
no mini-batch).}

\item{minibatch_reps}{a number, how many times repeat computations with a 
fraction of samples (more times - better performance). 
The default is 1 (as a companion to default fraction of 100\%. i.e. no mini-batch).}
}
\value{
A numeric matrix \eqn{out} with imputed data is returned.
}
\description{
Impute missing values in methylation dataset
}
\keyword{internal}
