#' WGBS for colon cancer, chr21 and chr22
#'
#' This is a subset of original `bsseqData` converted to `methrix` containing Whole-genome bisulfite sequencing data (WGBS)
#' for colon cancer on chromosome 21 and 22.
#'
#' @docType data
#'
#' @usage data('methrix_data')
#'
#' @format An object of class \code{'methrix'}
#'
#' @keywords datasets
#'
#' @references Hansen, K. D. et al. (2011) Increased methylation variation in epigenetic domains across cancer types.
#' Nature Genetics 43, 768-775.
#'
#'
#' @examples
#' data('methrix_data')
#' methrix_data
"methrix_data"
