% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmr_functions.R
\name{.test_tmrs}
\alias{.test_tmrs}
\title{Find TMRs where smoothed methodical scores exceed thresholds}
\usage{
.test_tmrs(
  meth_sites_gr,
  smoothed_methodical_scores,
  p_value_threshold = 0.05,
  tss_gr = NULL,
  transcript_id = NULL
)
}
\arguments{
\item{meth_sites_gr}{A GRanges object with the location of methylation sites.}

\item{smoothed_methodical_scores}{A numeric vector with the smoothed methodical scores associated with each methylation site.}

\item{p_value_threshold}{The p_value cutoff to use. Default value is 0.05.}

\item{tss_gr}{An optional GRanges object giving the location of the TSS meth_sites_gr is associated with.}

\item{transcript_id}{Name of the transcript associated with the TSS.}
}
\value{
A GRanges object with the location of TMRs.
}
\description{
Find TMRs where smoothed methodical scores exceed thresholds
}
