% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadFromFiles.R
\name{loadFromFiles}
\alias{loadFromFiles}
\title{Load \pkg{methimpute} objects from file}
\usage{
loadFromFiles(files, check.class = c("GRanges", "methimputeBinomialHMM"))
}
\arguments{
\item{files}{A list of \code{\link{GRanges-class}} or \code{\link{methimputeBinomialHMM}} objects or a character vector with files that contain such objects.}

\item{check.class}{Any combination of \code{c('GRanges', 'methimputeBinomialHMM')}. If any of the loaded objects does not belong to the specified class, an error is thrown.}
}
\value{
A list of \code{\link{GRanges-class}} or \code{\link{methimputeBinomialHMM}} objects.
}
\description{
Wrapper to load \pkg{\link{methimpute}} objects from file and check the class of the loaded objects.
}
\examples{
## Get some files that you want to load
file <- system.file("data","arabidopsis_toydata.RData",
                    package="methimpute")
## Load and print
data <- loadFromFiles(file)
print(data)

}
