% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{distanceCorrelation}
\alias{distanceCorrelation}
\title{Distance correlation}
\usage{
distanceCorrelation(data, distances = 0:50, separate.contexts = FALSE)
}
\arguments{
\item{data}{A \code{\link{methimputeData}} object.}

\item{distances}{An integer vector specifying the distances for which the correlation will be calculated.}

\item{separate.contexts}{A logical indicating whether contexts are treated separately. If set to \code{TRUE}, correlations will only be calculated between cytosines of the same context.}
}
\value{
A list() with an array containing the correlation values and the corresponding \code{\link[ggplot2]{ggplot}}.
}
\description{
Compute the distance correlation from a \code{\link{methimputeData}} object.
}
\examples{
## Get some toy data
file <- system.file("data","arabidopsis_toydata.RData",
                    package="methimpute")
data <- get(load(file))
distcor <- distanceCorrelation(data)
print(distcor$plot)

}
