% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{validateRunSimIntegerParameters}
\alias{validateRunSimIntegerParameters}
\title{Parameters validation for the \code{\link{runSim}} function. Only
integer parameters are validated.}
\usage{
validateRunSimIntegerParameters(nbSynCHR, nbSimulation, nbBlock, nbCpG,
  vNbSample, nbGeneration, minReads, meanCov, nbCores, vSeed)
}
\arguments{
\item{nbSynCHR}{a positive \code{integer}, the number of distinct 
synthetic chromosomes that will be generated.}

\item{nbSimulation}{a positive \code{integer}, the number of simulations 
for each parameter (\code{vNbSample}, \code{vpDiff}, \code{vDiff} and
\code{vInheritance}).}

\item{nbBlock}{a positive \code{integer}, the number of blocks used 
for sampling.}

\item{nbCpG}{a positive \code{integer}, the number of consecutive CpG 
positions used for sampling from \code{methInfo}.}

\item{vNbSample}{a \code{vector} of positive \code{integer}, the number of 
methData (CTRL) and cases in the the simulation dataset. In 
the simulated dataset, the number of CTRL equals the number of Case. 
The number of CTRL do not need to be equal to the number of Case in
the real dataset.}

\item{nbGeneration}{a positive \code{integer}, the number of generations.}

\item{minReads}{a positive \code{integer} Bases and regions having lower
coverage than this count are discarded. The parameter
correspond to the \code{lo.count} parameter in the \code{methylKit} package.}

\item{meanCov}{a positive \code{integer} represent the mean of the coverage
at the CpG site Default: \code{80}.}

\item{nbCores}{a positive \code{integer}, the number of cores to use when
creating the simulated datasets. Default: \code{1} and always 
\code{1} for Windows.}

\item{vSeed}{a \code{integer}, a seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: \code{-1}.}
}
\value{
\code{0} indicating that the function has been successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{runSim}} function. Only integer parameters are validated.
}
\examples{

## The function returns 0 when all paramaters are valid
methInheritSim:::validateRunSimIntegerParameters(nbSynCHR = 1, 
nbSimulation = 2, nbBlock = 10, nbCpG = 4, vNbSample = 10, 
nbGeneration = 3, minReads = 10, meanCov = 80, 
nbCores = 1, vSeed = -1)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
