[![Build Status](https://travis-ci.org/belleau/methInheritSim.svg?branch=master)](https://travis-ci.org/belleau/methInheritSim)
[![codecov](https://codecov.io/gh/belleau/methInheritSim/branch/master/graph/badge.svg)](https://codecov.io/gh/belleau/methInheritSim)
[![License: Artistic-2.0](https://img.shields.io/badge/License-Artistic%202.0-0298c3.svg)](https://opensource.org/licenses/Artistic-2.0)

# Whole-Genome Inherited Bisulphite Sequencing Data Simulation #

The **methInheritSim** package generates simulated multigenerational DMS datasets that are useful to evaluate the power and the false discovery rate of experiment design analysis, such as the methylInheritance [methylInheritance](http://bioconductor.org/packages/methylInheritance) package does. The multigenerational DMS datasets can also be used to compare the efficiency of different inheritance detection software.

## Citing ##

If you use this package for a publication, we would ask you to cite the 
following:

> Pascal Belleau, Astrid Deschênes, Marie-Pier Scott-Boyer, Romain Lambrot, Mathieu Dalvai, Sarah Kimmins, Janice Bailey, Arnaud Droit; Inferring and modeling inheritance of differentially methylated changes across multiple generations, Nucleic Acids Research, Volume 46, Issue 14, 21 August 2018, Pages e85. DOI: https://doi.org/10.1093/nar/gky362


## Bioconductor Package ##

[![Bioconductor Time](http://bioconductor.org/shields/years-in-bioc/methInheritSim.svg)](http://bioconductor.org/packages/release/bioc/html/methInheritSim.html "Bioconductor status")

**methInheritSim** is now an official package of [Bioconductor](http://bioconductor.org/). The current release can be directly downloaded from their website:
[Current release](http://bioconductor.org/packages/methInheritSim)


## Description of Package Functionality ##

The vignette of the **methInheritSim** package, which is a document that provides a task-oriented description of the package functionality, is available on Bioconductor website: [methInheritSim vignette](http://bioconductor.org/packages/release/bioc/vignettes/methInheritSim/inst/doc/methInheritSim.html)


## Authors ##

[Pascal Belleau](http://ca.linkedin.com/in/pascalbelleau "Pascal Belleau"),
[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes "Astrid Desch&ecirc;nes")
and [Arnaud Droit](http://ca.linkedin.com/in/drarnaud "Arnaud Droit").

See [Arnaud Droit Lab](http://bioinformatique.ulaval.ca "Arnaud Droit Lab") 
website.


## Maintainer ##

[Pascal Belleau](http://ca.linkedin.com/in/pascalbelleau "Pascal Belleau")


## License ##

This package and the underlying **methInheritSim** code are distributed under the 
Artistic license 2.0. You are free to use and redistribute this software. 

For more information on Artistic 2.0 License see
[http://opensource.org/licenses/Artistic-2.0](http://opensource.org/licenses/Artistic-2.0)


## Bugs/Feature requests ##

If you have any bugs or feature requests, 
[let us know](https://github.com/belleau/methInheritSim/issues). 

Thanks!
