% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/class_def.R
\name{do_query}
\alias{do_query}
\alias{do_query,character,character,character,character-method}
\alias{do_query,mw_moverz_context,list,character,mw_output_item-method}
\alias{do_query,mw_moverz_context,list,character,character-method}
\alias{do_query,mw_moverz_context,list,character,missing-method}
\alias{do_query,mw_moverz_context,character,character,missing-method}
\alias{do_query,character,character,character,missing-method}
\alias{do_query,mw_exactmass_context,list,character,mw_output_item-method}
\alias{do_query,mw_exactmass_context,list,character,character-method}
\alias{do_query,mw_exactmass_context,list,character,missing-method}
\alias{do_query,mw_exactmass_context,character,character,missing-method}
\alias{do_query,mw_context,mw_input_item,character,mw_output_item-method}
\alias{do_query,mw_context,mw_input_item,character,mw_SE_item-method}
\alias{do_query,mw_context,mw_input_item,character,mw_untarg_SE_item-method}
\alias{do_query,mw_context,mw_input_item,character,mw_DE_item-method}
\alias{do_query,mw_context,mw_input_item,character,mw_untarg_DE_item-method}
\alias{do_query,mw_context,mw_input_item,character,mw_MAE_item-method}
\title{Query the Metabolomics Workbench database}
\usage{
do_query(context, input_item, input_value, output_item)

\S4method{do_query}{character,character,character,character}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_moverz_context,list,character,mw_output_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_moverz_context,list,character,character}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_moverz_context,list,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_moverz_context,character,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{character,character,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_exactmass_context,list,character,mw_output_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_exactmass_context,list,character,character}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_exactmass_context,list,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_exactmass_context,character,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{character,character,character,missing}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_output_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_SE_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_untarg_SE_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_DE_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_untarg_DE_item}(context, input_item, input_value, output_item)

\S4method{do_query}{mw_context,mw_input_item,character,mw_MAE_item}(context, input_item, input_value, output_item)
}
\arguments{
\item{context}{A valid context name (character)}

\item{input_item}{A valid input_item name (character)}

\item{input_value}{The value for the input item (character).}

\item{output_item}{A valid output_item (character).}
}
\value{
A data.frame, or other output appropriate to the output_item.
}
\description{
Sends a query to the metabolomics database and returns the result. Note that
while objects derived from mw_base can be used the recommended approach is to
use character inputs.
}
\examples{
# Get a summary of all studies with "diabetes" in the title
\donttest{
df = do_query(
  context = 'study',
  input_item = 'study_title',
  input_value = 'diabetes',
  output_item = 'summary'  
)
}
}
