% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-metabCombiner.R, R/plot_fit.R
\name{plot,metabCombiner,ANY-method}
\alias{plot,metabCombiner,ANY-method}
\alias{plot_fit}
\title{Plot metabCombiner Fits}
\usage{
\S4method{plot}{metabCombiner,ANY}(x, y, ...)

plot_fit(
  object,
  fit = c("gam", "loess"),
  pcol = "black",
  lcol = "red",
  lwd = 3,
  pch = 19,
  outlier = "show",
  ocol = "springgreen4",
  legend = c("anchor", "outlier"),
  ...
)
}
\arguments{
\item{x}{\code{metabCombiner} object}

\item{y}{...}

\item{...}{Other variables passed into graphics::plot}

\item{object}{metabCombiner object}

\item{fit}{choice of model (either "gam" or "loess").}

\item{pcol}{color of the normal points (ordered RT pair) in the plot}

\item{lcol}{color of the fitted line in the plot}

\item{lwd}{line width of the curve fit between anchor points}

\item{pch}{plot character type; see ?graphics::par for details}

\item{outlier}{display option for outliers. If "show" or "s", treats
outlier points like normal anchors; if "remove" or "r", removes outlier
points from the plot; if "highlight" or "h", displays outliers with a
different color and associated legend.}

\item{ocol}{color of the outlier points; outlier argument must be set to
"highlight" or "h"}

\item{legend}{length-2 character vector indicating point labels in the legend
if outlier argument set to "highlight" or "h"}
}
\value{
no values returned
}
\description{
This is a plotting method for metabCombiner objects. It displays
ordered pairs and a curve fit computed using \code{fit_gam} or
\code{fit_loess}, using base R graphics.
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(plasma30, samples = "CHEAR")
p20 <- metabData(plasma20, samples = "Red", rtmax = 17.25)
p.comb = metabCombiner(xdata = p30, ydata = p20, binGap = 0.0075)
p.comb = selectAnchors(p.comb, tolmz = 0.003, tolQ = 0.3, windy = 0.02)
p.comb = fit_gam(p.comb, k = 20, iterFilter = 1, family = "gaussian")

##plot of GAM fit
plot(p.comb, main = "Example GAM Fit Plot", xlab = "X Dataset RTs",
     ylab = "Y Dataset RTs", pcol = "red", lcol = "blue", lwd = 5,
     fit = "gam", outliers = "remove")

grid(lwd =  2, lty = 3 ) #adding gridlines

}
