% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-metabCombiner.R
\name{datasets}
\alias{datasets}
\alias{datasets,metabCombiner-method}
\title{Obtain Dataset IDs}
\usage{
datasets(object, list = FALSE)

\S4method{datasets}{metabCombiner}(object, list = FALSE)
}
\arguments{
\item{object}{metabCombiner object}

\item{list}{logical, option to return in list format (TRUE) vs character
vector format (FALSE)}
}
\value{
character vector of dataset identifiers
}
\description{
Each dataset in a \code{metabCombiner} object is represented by
a character identifier. The datasets slot contains all these ids in a single
vector, which can be obtained in sequential order with this accessor method
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")

p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##datasets extraction: expect "p30", "p20"
sets <- datasets(p.comb, list = FALSE)

}
