% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{adductData}
\alias{adductData}
\alias{adductData,metabCombiner-method}
\title{Retrieve Adduct Annotations}
\usage{
adductData(object, data = NULL)

\S4method{adductData}{metabCombiner}(object, data = NULL)
}
\arguments{
\item{object}{\code{metabCombiner} object}

\item{data}{dataset identifier to extract information from; if NULL, extracts
information from all datasets}
}
\value{
data frame of adduct annotations
}
\description{
This retrieves user-assigned adduct annotations from one or
all constituent datasets of a \code{metabCombiner} object
}
\examples{
data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")

p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##retrieve all adduct data
adducts <- adductData(p.comb, data = NULL)

##retrieve adduct data from p30
adducts <- adductData(p.comb, data = "p30")

}
