% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fimo.R
\name{runFimo}
\alias{runFimo}
\title{Find instances of motifs using FIMO}
\usage{
runFimo(
  sequences,
  motifs,
  bfile = "motif",
  outdir = "auto",
  parse_genomic_coord = TRUE,
  skip_matched_sequence = FALSE,
  max_strand = TRUE,
  text = TRUE,
  meme_path = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{sequences}{path to fasta file, or stringset input.}

\item{motifs}{path to .meme format file, or universalmotif/universalmotif list input.}

\item{bfile}{path to background file, or special values: "motif" to use
0-order frequencies contained in the motif, or "uniform" to use a uniform
letter distribution. (default: "motif")}

\item{outdir}{output directory location. Only used if text = FALSE. Default:
"auto" to autogenerate directory name. Note: if not using a fasta path as
input, this will be a temporary location unless explicity set.}

\item{parse_genomic_coord}{\code{logical(1)} whether to parse genomic position
from fasta headers. Fasta headers must be UCSC format positions (ie
"chr:start-end"), but base 1 indexed (GRanges format). If names of fasta
entries are genomic coordinates and parse_genomic_coord == TRUE, results
will contain genomic coordinates of motif matches, otherwise FIMO will return
relative coordinates (i.e. positions from 1 to length of the fasta entry).}

\item{skip_matched_sequence}{\code{logical(1)} whether or not to include the DNA
sequence of the match. Default: \code{FALSE}. Note: jobs will complete faster if
set to \code{TRUE}. \code{add_sequence()} can be used to lookup the sequence after data import if
\code{parse_genomic_coord} is \code{TRUE}, so setting this flag is not strictly needed.}

\item{max_strand}{if match is found on both strands, only report strand with
best match (default: TRUE).}

\item{text}{\code{logical(1)} (default: \code{TRUE}). No output files will be created
on the filesystem. The results are unsorted and no q-values are computed.
This setting allows fast searches on very large inputs. When set to \code{FALSE}
FIMO will discard 50\% of the lower significance matches if >100,000 matches are
detected. \code{text = FALSE} will also incur a performance penalty because it
must first read a file to disk, then read it into memory. For these reasons,
I suggest keeping \code{text = TRUE}.}

\item{meme_path}{path to \verb{meme/bin/} (optional). Defaut: \code{NULL}, searches
"MEME_PATH" environment variable or "meme_path" option for path to "meme/bin/".}

\item{silent}{\code{logical(1)} whether to suppress stdout/stderr printing to
console (default: TRUE). If the command is failing or giving unexpected
output, setting \code{silent = FALSE} can aid troubleshooting.}

\item{...}{additional commandline arguments to fimo. See the FIMO Flag table below.}
}
\value{
GRanges object containing positions of each match. Note: if
\code{parse_genomic_coords = FALSE}, each \code{seqnames} entry will be the full fasta
header, and start/end will be the relative position within that sequence of the
match. The GRanges object has the following additional \code{mcols}:
* motif_id = primary name of matched motif
* motif_alt_id = alternate name of matched motif
* score = score of match (higher score is a better match)
* pvalue = pvalue of the match
* qvalue = qvalue of the match
* matched_sequence = sequence that matches the motif
}
\description{
FIMO scans input sequences to identify the positions of matches to each input
motif. FIMO has no sequence length or motif number restrictions.
}
\details{
Additional arguments passed to \code{...}. See: \href{http://meme-suite.org/doc/fimo.html?man_type=web}{Fimo web manual}
for a complete description of FIMO flags.\tabular{cccl}{
   FIMO Flag \tab allowed values \tab default \tab description \cr
   alpha \tab \code{numeric(1)} \tab 1 \tab alpha for calculating position-specific priors. Represents fraction of sites that are binding sites of TF of interest. Used in conjunction with \code{psp} \cr
   bfile \tab "motif", "motif-file", "uniform", file path, \tab "motif" \tab If "motif" or "motif-file", use 0-order letter frequencies from motif. "uniform" sets uniform letter frequencies. \cr
   max_stored_scores \tab \code{integer(1)} \tab NULL \tab maximum number of scores to be stored for computing q-values. used when \code{text = FALSE}, see FIMO webpage for details \cr
   motif_pseudo \tab \code{numeric(1)} \tab 0.1 \tab pseudocount added to motif matrix \cr
   no_qvalue \tab \code{logical(1)} \tab FALSE \tab only needed when \code{text = FALSE}, do not compute q-value for each p-value \cr
   norc \tab \code{logical(1)} \tab FALSE \tab Do not score reverse complement strand \cr
   prior_dist \tab file path \tab NULL \tab file containing binned distribution of priors \cr
   psp \tab file path \tab NULL \tab file containing position specific priors. Requires \code{prior_dist} \cr
   qv_thresh \tab \code{logical(1)} \tab FALSE \tab use q-values for the output threshold \cr
   thresh \tab \code{numeric(1)} \tab \code{1e-4} \tab output threshold for returning a match, only matches with values less than \code{thresh} are returned. \cr
}

\subsection{Licensing}{

The MEME Suite is free for non-profit use, but for-profit users should purchase a
license. See the \href{http://meme-suite.org/doc/copyright.html}{MEME Suite Copyright Page} for details.
}
}
\section{Citation}{
If you use \code{runFimo()} in your analysis, please cite:

Charles E. Grant, Timothy L. Bailey, and William Stafford Noble, "FIMO:
Scanning for occurrences of a given motif", Bioinformatics, 27(7):1017-1018,
2011. \href{http://bioinformatics.oxfordjournals.org/content/early/2011/02/16/bioinformatics.btr064.full}{full text}
}

\examples{
if (meme_is_installed()){
# Generate some example input sequences
seq <- universalmotif::create_sequences()
# sequences must have values in their fasta headers
names(seq) <- seq_along(seq)
# Create random example motif to search for
motif <- universalmotif::create_motif()

# Search for motif in sequences
# parse_genomic_coord set to FALSE since fasta headers aren't in "chr:start-end" format.
runFimo(seq, motif, parse_genomic_coord = FALSE)
}
}
