% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_utils.R
\name{nest_tomtom}
\alias{nest_tomtom}
\title{Nest TomTom results columns into a data.frame column named "tomtom"}
\usage{
nest_tomtom(data)
}
\arguments{
\item{data}{tomtom results data.frame after unnesting the `tomtom` column}
}
\value{
the input data.frame with the match_* columns nested into a column named `tomtom`
}
\description{
This is a convienience function for re-nesting the `tomtom` list column if
the user unnests it. Additionally, it will update the best_match information
based on the ranking of the resulting `tomtom` data.frame. This avoids having
out-of-date best_match information after manipulating the `tomtom` entries.
}
\details{
**NOTE:** that the resulting columns may not be in the same order, so
operations like `identical()` before & after a nest/renest operation may fail
even though the column values are unchanged.
}
\examples{
if (meme_is_installed()){
motif <- universalmotif::create_motif("CCRAAAW")
db <- system.file("extdata/flyFactorSurvey_cleaned.meme", package = "memes")
res <- runTomTom(motif, database = db)
data <- tidyr::unnest(res, "tomtom")
identical(nest_tomtom(data), res)
}
}
